/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import org.mapstruct.ap.shaded.freemarker.core.BugException;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.TemplateElement;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;

final class ConditionalBlock
extends TemplateElement {
    static final int TYPE_IF = 0;
    static final int TYPE_ELSE = 1;
    static final int TYPE_ELSE_IF = 2;
    final Expression condition;
    private final int type;
    boolean isLonelyIf;

    ConditionalBlock(Expression condition, TemplateElement nestedBlock, int type) {
        this.condition = condition;
        this.nestedBlock = nestedBlock;
        this.type = type;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if ((this.condition == null || this.condition.evalToBoolean(env)) && this.nestedBlock != null) {
            env.visitByHiddingParent(this.nestedBlock);
        }
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        if (this.condition != null) {
            buf.append(' ');
            buf.append(this.condition.getCanonicalForm());
        }
        if (canonical) {
            buf.append(">");
            if (this.nestedBlock != null) {
                buf.append(this.nestedBlock.getCanonicalForm());
            }
            if (this.isLonelyIf) {
                buf.append("</#if>");
            }
        }
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        if (this.type == 1) {
            return "#else";
        }
        if (this.type == 0) {
            return "#if";
        }
        if (this.type == 2) {
            return "#elseif";
        }
        throw new BugException("Unknown type");
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.condition;
            }
            case 1: {
                return new Integer(this.type);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.CONDITION;
            }
            case 1: {
                return ParameterRole.AST_NODE_SUBTYPE;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

