/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.HashSet;
import java.util.Set;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NormalTypeMappingMethod;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;

public class IterableCreation
extends ModelElement {
    private final Type resultType;
    private final Parameter sourceParameter;
    private final MethodReference factoryMethod;
    private final boolean canUseSize;
    private final boolean loadFactorAdjustment;

    private IterableCreation(Type resultType, Parameter sourceParameter, MethodReference factoryMethod) {
        this.resultType = resultType;
        this.sourceParameter = sourceParameter;
        this.factoryMethod = factoryMethod;
        this.canUseSize = (sourceParameter.getType().isCollectionOrMapType() || sourceParameter.getType().isArrayType()) && resultType.getImplementation() != null && resultType.getImplementation().hasInitialCapacityConstructor();
        this.loadFactorAdjustment = this.canUseSize && resultType.getImplementation().isLoadFactorAdjustment();
    }

    public static IterableCreation create(NormalTypeMappingMethod mappingMethod, Parameter sourceParameter) {
        return new IterableCreation(mappingMethod.getResultType(), sourceParameter, mappingMethod.getFactoryMethod());
    }

    public Type getResultType() {
        return this.resultType;
    }

    public Parameter getSourceParameter() {
        return this.sourceParameter;
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }

    public boolean isCanUseSize() {
        return this.canUseSize;
    }

    public boolean isLoadFactorAdjustment() {
        return this.loadFactorAdjustment;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> types = new HashSet<Type>();
        if (this.factoryMethod == null && this.resultType.getImplementationType() != null) {
            types.addAll(this.resultType.getImplementationType().getImportTypes());
        }
        if (this.isEnumSet()) {
            types.add(this.getEnumSetElementType());
            types.add(this.resultType);
        }
        return types;
    }

    public Type getEnumSetElementType() {
        return Collections.first(this.getResultType().determineTypeArguments(Iterable.class));
    }

    public boolean isEnumSet() {
        return "java.util.EnumSet".equals(this.resultType.getFullyQualifiedName());
    }
}

