/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.Constructor;
import org.mapstruct.ap.internal.model.Decorator;
import org.mapstruct.ap.internal.model.Field;
import org.mapstruct.ap.internal.model.GeneratedType;
import org.mapstruct.ap.internal.model.Javadoc;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.NoArgumentConstructor;
import org.mapstruct.ap.internal.model.SupportingConstructorFragment;
import org.mapstruct.ap.internal.model.common.Accessibility;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.version.VersionInformation;

public class Mapper
extends GeneratedType {
    static final String CLASS_NAME_PLACEHOLDER = "<CLASS_NAME>";
    static final String PACKAGE_NAME_PLACEHOLDER = "<PACKAGE_NAME>";
    static final String DEFAULT_IMPLEMENTATION_CLASS = "<CLASS_NAME>Impl";
    static final String DEFAULT_IMPLEMENTATION_PACKAGE = "<PACKAGE_NAME>";
    private final boolean customPackage;
    private final boolean customImplName;
    private Decorator decorator;
    private final Javadoc javadoc;

    private Mapper(TypeFactory typeFactory, String packageName, String name, Type mapperDefinitionType, boolean customPackage, boolean customImplName, Set<Annotation> customAnnotations, List<MappingMethod> methods, Options options, VersionInformation versionInformation, boolean suppressGeneratorTimestamp, Accessibility accessibility, List<Field> fields, Constructor constructor, Decorator decorator, SortedSet<Type> extraImportedTypes, Javadoc javadoc) {
        super(typeFactory, packageName, name, mapperDefinitionType, methods, fields, options, versionInformation, suppressGeneratorTimestamp, accessibility, extraImportedTypes, constructor);
        this.customPackage = customPackage;
        this.customImplName = customImplName;
        customAnnotations.forEach(this::addAnnotation);
        this.decorator = decorator;
        this.javadoc = javadoc;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void removeDecorator() {
        this.decorator = null;
    }

    public boolean hasCustomImplementation() {
        return this.customImplName || this.customPackage;
    }

    @Override
    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    @Override
    protected String getTemplateName() {
        return this.getTemplateNameForClass(GeneratedType.class);
    }

    public static String getFlatName(TypeElement element) {
        if (!(element.getEnclosingElement() instanceof TypeElement)) {
            return element.getSimpleName().toString();
        }
        StringBuilder nameBuilder = new StringBuilder(element.getSimpleName().toString());
        Element enclosing = element.getEnclosingElement();
        while (enclosing instanceof TypeElement) {
            nameBuilder.insert(0, '$');
            nameBuilder.insert(0, enclosing.getSimpleName().toString());
            enclosing = enclosing.getEnclosingElement();
        }
        return nameBuilder.toString();
    }

    public static class Builder
    extends GeneratedType.GeneratedTypeBuilder<Builder> {
        private TypeElement element;
        private List<Field> fields;
        private Set<SupportingConstructorFragment> fragments;
        private Decorator decorator;
        private String implName;
        private boolean customName;
        private String implPackage;
        private boolean customPackage;
        private boolean suppressGeneratorTimestamp;
        private Set<Annotation> customAnnotations;
        private Javadoc javadoc;

        public Builder() {
            super(Builder.class);
        }

        public Builder element(TypeElement element) {
            this.element = element;
            return this;
        }

        public Builder fields(List<Field> fields) {
            this.fields = fields;
            return this;
        }

        public Builder constructorFragments(Set<SupportingConstructorFragment> fragments) {
            this.fragments = fragments;
            return this;
        }

        public Builder additionalAnnotations(Set<Annotation> customAnnotations) {
            this.customAnnotations = customAnnotations;
            return this;
        }

        public Builder decorator(Decorator decorator) {
            this.decorator = decorator;
            return this;
        }

        public Builder implName(String implName) {
            this.implName = implName;
            this.customName = !Mapper.DEFAULT_IMPLEMENTATION_CLASS.equals(this.implName);
            return this;
        }

        public Builder implPackage(String implPackage) {
            this.implPackage = implPackage;
            this.customPackage = !"<PACKAGE_NAME>".equals(this.implPackage);
            return this;
        }

        public Builder suppressGeneratorTimestamp(boolean suppressGeneratorTimestamp) {
            this.suppressGeneratorTimestamp = suppressGeneratorTimestamp;
            return this;
        }

        public Builder javadoc(Javadoc javadoc) {
            this.javadoc = javadoc;
            return this;
        }

        public Mapper build() {
            String implementationName = this.implName.replace(Mapper.CLASS_NAME_PLACEHOLDER, Mapper.getFlatName(this.element)) + (this.decorator == null ? "" : "_");
            String elementPackage = this.elementUtils.getPackageOf(this.element).getQualifiedName().toString();
            String packageName = this.implPackage.replace("<PACKAGE_NAME>", elementPackage);
            NoArgumentConstructor constructor = null;
            if (!this.fragments.isEmpty()) {
                constructor = new NoArgumentConstructor(implementationName, this.fragments);
            }
            Type definitionType = this.typeFactory.getType(this.element);
            return new Mapper(this.typeFactory, packageName, implementationName, definitionType, this.customPackage, this.customName, this.customAnnotations, this.methods, this.options, this.versionInformation, this.suppressGeneratorTimestamp, Accessibility.fromModifiers(this.element.getModifiers()), this.fields, constructor, this.decorator, this.extraImportedTypes, this.javadoc);
        }
    }
}

