/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.gem.ValueMappingGem;
import org.mapstruct.ap.internal.gem.ValueMappingsGem;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;

public class ValueMappingOptions {
    private final String source;
    private final String target;
    private final AnnotationMirror mirror;
    private final AnnotationValue sourceAnnotationValue;
    private final AnnotationValue targetAnnotationValue;

    public static void fromMappingsGem(ValueMappingsGem mappingsGem, ExecutableElement method, FormattingMessager messager, Set<ValueMappingOptions> mappings) {
        boolean anyFound = false;
        for (ValueMappingGem mappingGem : mappingsGem.value().get()) {
            ValueMappingOptions mapping = ValueMappingOptions.fromMappingGem(mappingGem);
            if (mapping == null) continue;
            if (!mappings.contains(mapping)) {
                mappings.add(mapping);
            } else {
                messager.printMessage((Element)method, mappingGem.mirror(), mappingGem.target().getAnnotationValue(), Message.VALUEMAPPING_DUPLICATE_SOURCE, mappingGem.source().get());
            }
            if (!"<ANY_REMAINING>".equals(mapping.source) && !"<ANY_UNMAPPED>".equals(mapping.source)) continue;
            if (anyFound) {
                messager.printMessage((Element)method, mappingGem.mirror(), mappingGem.target().getAnnotationValue(), Message.VALUEMAPPING_ANY_AREADY_DEFINED, mappingGem.source().get());
            }
            anyFound = true;
        }
    }

    public static ValueMappingOptions fromMappingGem(ValueMappingGem mapping) {
        return new ValueMappingOptions(mapping.source().get(), mapping.target().get(), mapping.mirror(), mapping.source().getAnnotationValue(), mapping.target().getAnnotationValue());
    }

    private ValueMappingOptions(String source, String target, AnnotationMirror mirror, AnnotationValue sourceAnnotationValue, AnnotationValue targetAnnotationValue) {
        this.source = source;
        this.target = target;
        this.mirror = mirror;
        this.sourceAnnotationValue = sourceAnnotationValue;
        this.targetAnnotationValue = targetAnnotationValue;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public AnnotationValue getSourceAnnotationValue() {
        return this.sourceAnnotationValue;
    }

    public AnnotationValue getTargetAnnotationValue() {
        return this.targetAnnotationValue;
    }

    public ValueMappingOptions inverse() {
        ValueMappingOptions result = !"<ANY_REMAINING>".equals(this.source) && !"<ANY_UNMAPPED>".equals(this.source) && !"<THROW_EXCEPTION>".equals(this.target) ? new ValueMappingOptions(this.target, this.source, this.mirror, this.sourceAnnotationValue, this.targetAnnotationValue) : null;
        return result;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.source != null ? this.source.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueMappingOptions other = (ValueMappingOptions)obj;
        return Objects.equals(this.source, other.source);
    }
}

