/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.metrics.ConnectionPoolMetricsListener;
import org.neo4j.driver.internal.metrics.InternalHistogram;
import org.neo4j.driver.internal.metrics.InternalMetrics;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.spi.ConnectionPoolMetrics;
import org.neo4j.driver.internal.metrics.spi.Histogram;
import org.neo4j.driver.internal.metrics.spi.PoolStatus;
import org.neo4j.driver.internal.spi.ConnectionPool;

public class InternalConnectionPoolMetrics
implements ConnectionPoolMetrics,
ConnectionPoolMetricsListener {
    private final BoltServerAddress address;
    private final ConnectionPool pool;
    private final AtomicLong closed = new AtomicLong();
    private final AtomicInteger creating = new AtomicInteger();
    private final AtomicLong created = new AtomicLong();
    private final AtomicLong failedToCreate = new AtomicLong();
    private final AtomicInteger acquiring = new AtomicInteger();
    private final AtomicLong acquired = new AtomicLong();
    private final AtomicLong timedOutToAcquire = new AtomicLong();
    private InternalHistogram acquisitionTimeHistogram;

    public InternalConnectionPoolMetrics(BoltServerAddress address, ConnectionPool pool, long connAcquisitionTimeoutMs) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(pool);
        this.address = address;
        this.pool = pool;
        this.acquisitionTimeHistogram = new InternalHistogram(Duration.ofMillis(connAcquisitionTimeoutMs).toNanos());
    }

    @Override
    public void beforeCreating() {
        this.creating.incrementAndGet();
    }

    @Override
    public void afterFailedToCreate() {
        this.failedToCreate.incrementAndGet();
        this.creating.decrementAndGet();
    }

    @Override
    public void afterCreated() {
        this.created.incrementAndGet();
        this.creating.decrementAndGet();
    }

    @Override
    public void afterClosed() {
        this.closed.incrementAndGet();
    }

    @Override
    public void beforeAcquiringOrCreating(ListenerEvent listenerEvent) {
        listenerEvent.start();
        this.acquiring.incrementAndGet();
    }

    @Override
    public void afterAcquiringOrCreating() {
        this.acquiring.decrementAndGet();
    }

    @Override
    public void afterAcquiredOrCreated(ListenerEvent listenerEvent) {
        long elapsed = listenerEvent.elapsed();
        this.acquisitionTimeHistogram.recordValue(elapsed);
        this.acquired.incrementAndGet();
    }

    @Override
    public void afterTimedOutToAcquireOrCreate() {
        this.timedOutToAcquire.incrementAndGet();
    }

    @Override
    public String uniqueName() {
        return InternalMetrics.serverAddressToUniqueName(this.address);
    }

    @Override
    public PoolStatus poolStatus() {
        if (this.pool.isOpen(this.address)) {
            return PoolStatus.OPEN;
        }
        return PoolStatus.CLOSED;
    }

    @Override
    public int inUse() {
        return this.pool.inUseConnections(this.address);
    }

    @Override
    public int idle() {
        return this.pool.idleConnections(this.address);
    }

    @Override
    public int creating() {
        return this.creating.get();
    }

    @Override
    public long created() {
        return this.created.get();
    }

    @Override
    public long failedToCreate() {
        return this.failedToCreate.get();
    }

    @Override
    public long timedOutToAcquire() {
        return this.timedOutToAcquire.get();
    }

    @Override
    public long closed() {
        return this.closed.get();
    }

    @Override
    public int acquiring() {
        return this.acquiring.get();
    }

    @Override
    public long acquired() {
        return this.acquired.get();
    }

    @Override
    public Histogram acquisitionTimeHistogram() {
        return this.acquisitionTimeHistogram.snapshot();
    }

    public String toString() {
        return String.format("[created=%s, closed=%s, creating=%s, failedToCreate=%s, acquiring=%s, acquired=%s, timedOutToAcquire=%s, inUse=%s, idle=%s, poolStatus=%s, acquisitionTimeHistogram=%s]", new Object[]{this.created(), this.closed(), this.creating(), this.failedToCreate(), this.acquiring(), this.acquired(), this.timedOutToAcquire(), this.inUse(), this.idle(), this.poolStatus(), this.acquisitionTimeHistogram()});
    }
}

