/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.jdbc.Wrapper;
import org.neo4j.jdbc.utils.ExceptionBuilder;

public abstract class Neo4jResultSetMetaData
implements ResultSetMetaData {
    protected final List<String> keys;

    protected Neo4jResultSetMetaData(List<String> keys) {
        this.keys = keys != null ? keys : new ArrayList<String>();
    }

    @Override
    public int getColumnCount() throws SQLException {
        int result = 0;
        if (this.keys != null) {
            result = this.keys.size();
        }
        return result;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        if (this.keys == null || column > this.keys.size() || column <= 0) {
            throw new SQLException("Column out of range");
        }
        return this.keys.get(column - 1);
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int type = this.getColumnType(column);
        int value = 0;
        if (type == 12) {
            value = 40;
        } else if (type == 4) {
            value = 10;
        } else if (type == 16) {
            value = 5;
        } else if (type == 6) {
            value = 15;
        } else if (type == 2000) {
            value = 60;
        }
        return value;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return column > 0 && column <= this.getColumnCount();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return Wrapper.unwrap(iface, this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return Wrapper.isWrapperFor(iface, this.getClass());
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return 12;
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return "String";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return String.class.getName();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }
}

