/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.BatchUpdateException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.summary.SummaryCounters;
import org.neo4j.jdbc.Loggable;
import org.neo4j.jdbc.Neo4jParameterMetaData;
import org.neo4j.jdbc.Neo4jPreparedStatement;
import org.neo4j.jdbc.Neo4jResultSetMetaData;
import org.neo4j.jdbc.bolt.BoltNeo4jConnection;
import org.neo4j.jdbc.bolt.BoltNeo4jParameterMetaData;
import org.neo4j.jdbc.bolt.BoltNeo4jResultSet;
import org.neo4j.jdbc.bolt.BoltNeo4jUtils;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jConnectionImpl;
import org.neo4j.jdbc.utils.Neo4jInvocationHandler;

public class BoltNeo4jPreparedStatement
extends Neo4jPreparedStatement
implements Loggable {
    private BoltNeo4jPreparedStatement(BoltNeo4jConnectionImpl connection, String rawStatement, int ... rsParams) {
        super(connection, rawStatement);
        this.resultSetParams = rsParams;
    }

    public static PreparedStatement newInstance(boolean debug, BoltNeo4jConnectionImpl connection, String rawStatement, int ... rsParams) {
        BoltNeo4jPreparedStatement ps = new BoltNeo4jPreparedStatement(connection, rawStatement, rsParams);
        ((Neo4jPreparedStatement)ps).setDebug(debug);
        return (PreparedStatement)Proxy.newProxyInstance(BoltNeo4jPreparedStatement.class.getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new Neo4jInvocationHandler(ps, debug));
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        StatementResult result = this.executeInternal();
        this.currentResultSet = BoltNeo4jResultSet.newInstance(this.hasDebug(), this, result, this.resultSetParams);
        this.currentUpdateCount = -1;
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        StatementResult result = this.executeInternal();
        SummaryCounters stats = result.consume().counters();
        this.currentUpdateCount = BoltNeo4jUtils.calculateUpdateCount(stats);
        this.currentResultSet = null;
        return this.currentUpdateCount;
    }

    @Override
    public boolean execute() throws SQLException {
        StatementResult result = this.executeInternal();
        boolean hasResultSet = this.hasResultSet();
        if (hasResultSet) {
            this.currentResultSet = BoltNeo4jResultSet.newInstance(this.hasDebug(), this, result, this.resultSetParams);
            this.currentUpdateCount = -1;
        } else {
            this.currentResultSet = null;
            try {
                SummaryCounters stats = result.consume().counters();
                this.currentUpdateCount = BoltNeo4jUtils.calculateUpdateCount(stats);
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        return hasResultSet;
    }

    private StatementResult executeInternal() throws SQLException {
        this.checkClosed();
        try {
            Transaction transaction = ((BoltNeo4jConnection)((Object)this.getConnection())).getTransaction();
            StatementResult result = transaction.run(this.statement, this.parameters);
            if (this.getConnection().getAutoCommit()) {
                ((BoltNeo4jConnection)((Object)this.getConnection())).doCommit();
            }
            return result;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private boolean hasResultSet() {
        return this.statement != null && this.statement.toLowerCase().contains("return");
    }

    @Override
    public Neo4jParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return new BoltNeo4jParameterMetaData(this);
    }

    @Override
    public Neo4jResultSetMetaData getMetaData() throws SQLException {
        return this.currentResultSet == null ? null : (Neo4jResultSetMetaData)this.currentResultSet.getMetaData();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        int[] result = new int[]{};
        try {
            for (Map parameter : this.batchParameters) {
                StatementResult res = ((BoltNeo4jConnection)((Object)this.connection)).getTransaction().run(this.statement, parameter);
                SummaryCounters count = res.consume().counters();
                result = Arrays.copyOf(result, result.length + 1);
                result[result.length - 1] = count.nodesCreated() + count.nodesDeleted();
                if (!this.connection.getAutoCommit()) continue;
                ((BoltNeo4jConnection)((Object)this.connection)).doCommit();
            }
        }
        catch (Exception e) {
            throw new BatchUpdateException(result, (Throwable)e);
        }
        return result;
    }

    protected void setTemporal(int parameterIndex, long epoch, ZoneId zone, Function<ZonedDateTime, Temporal> extractTemporal) throws SQLException {
        this.checkClosed();
        this.checkParamsNumber(parameterIndex);
        ZonedDateTime zdt = Instant.ofEpochMilli(epoch).atZone(zone);
        this.insertParameter(parameterIndex, extractTemporal.apply(zdt));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setTemporal(parameterIndex, x.getTime(), ZoneId.systemDefault(), zdt -> zdt.toLocalDate());
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTemporal(parameterIndex, x.getTime(), ZoneId.systemDefault(), zdt -> zdt.toLocalTime());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTemporal(parameterIndex, x.getTime(), ZoneId.systemDefault(), zdt -> zdt.toLocalDateTime());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTemporal(parameterIndex, x.getTime(), cal.getTimeZone().toZoneId(), zdt -> zdt);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setTemporal(parameterIndex, x.getTime(), cal.getTimeZone().toZoneId(), zdt -> zdt);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTemporal(parameterIndex, x.getTime(), cal.getTimeZone().toZoneId(), zdt -> zdt.toOffsetDateTime().toOffsetTime());
    }
}

