/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.neo4j.driver.internal.InternalIsoDuration;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.DateTimeValue;
import org.neo4j.driver.internal.value.DateValue;
import org.neo4j.driver.internal.value.DurationValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.LocalDateTimeValue;
import org.neo4j.driver.internal.value.LocalTimeValue;
import org.neo4j.driver.internal.value.NodeValue;
import org.neo4j.driver.internal.value.ObjectValueAdapter;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.internal.value.PointValue;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.internal.value.TimeValue;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.value.Uncoercible;
import org.neo4j.driver.v1.types.IsoDuration;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Point;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.driver.v1.types.Type;
import org.neo4j.driver.v1.util.Pair;
import org.neo4j.jdbc.Neo4jArray;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.Neo4jResultSet;
import org.neo4j.jdbc.bolt.BoltNeo4jResultSetMetaData;
import org.neo4j.jdbc.impl.ListArray;
import org.neo4j.jdbc.utils.Neo4jInvocationHandler;
import org.neo4j.jdbc.utils.ObjectConverter;

public class BoltNeo4jResultSet
extends Neo4jResultSet {
    private StatementResult iterator;
    private ResultSetMetaData metaData;
    private Record current;
    private List<String> keys;
    private List<Type> classes;
    private boolean flattened = false;
    private static final List<String> ACCEPTED_TYPES_FOR_FLATTENING = Arrays.asList("NODE", "RELATIONSHIP");
    private int flatten;
    private LinkedList<Record> prefetchedRecords = null;

    private BoltNeo4jResultSet(Statement statement, StatementResult iterator, int ... params) {
        super(statement, params);
        this.iterator = iterator;
        this.keys = new ArrayList<String>();
        this.classes = new ArrayList<Type>();
        this.prefetchedRecords = new LinkedList();
        try {
            this.flatten = ((Neo4jConnection)this.statement.getConnection()).getFlattening();
        }
        catch (Exception e) {
            this.flatten = 0;
        }
        if (this.flatten != 0 && this.iterator != null && this.iterator.hasNext() && this.iterator.peek() != null && this.flatteningTypes(this.iterator)) {
            this.flattenResultSet();
            this.flattened = true;
        } else if (this.iterator != null) {
            this.keys = this.iterator.keys();
            if (this.iterator.hasNext()) {
                for (Value value : this.iterator.peek().values()) {
                    this.classes.add(value.type());
                }
            }
        }
        this.metaData = BoltNeo4jResultSetMetaData.newInstance(false, this.classes, this.keys);
    }

    public static ResultSet newInstance(boolean debug, Statement statement, StatementResult iterator, int ... params) {
        BoltNeo4jResultSet rs = new BoltNeo4jResultSet(statement, iterator, params);
        return (ResultSet)Proxy.newProxyInstance(BoltNeo4jResultSet.class.getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new Neo4jInvocationHandler(rs, debug));
    }

    private void flattenResultSet() {
        for (int i = 0; (this.flatten == -1 || i < this.flatten) && this.iterator.hasNext(); ++i) {
            this.prefetchedRecords.add(this.iterator.next());
            this.flattenRecord(this.prefetchedRecords.getLast());
        }
    }

    private void flattenRecord(Record r) {
        for (Pair<String, Value> pair : r.fields()) {
            if (this.keys.indexOf(pair.key()) == -1) {
                this.keys.add(pair.key());
                this.classes.add(r.get(pair.key()).type());
            }
            Value val = r.get(pair.key());
            if (ACCEPTED_TYPES_FOR_FLATTENING.get(0).equals(pair.value().type().name())) {
                this.flattenNode(val.asNode(), pair.key());
                continue;
            }
            if (!ACCEPTED_TYPES_FOR_FLATTENING.get(1).equals(pair.value().type().name())) continue;
            this.flattenRelationship(val.asRelationship(), pair.key());
        }
    }

    private void flattenNode(Node node, String nodeKey) {
        if (this.keys.indexOf(nodeKey + ".id") == -1) {
            this.keys.add(nodeKey + ".id");
            this.classes.add(InternalTypeSystem.TYPE_SYSTEM.INTEGER());
            this.keys.add(nodeKey + ".labels");
            this.classes.add(InternalTypeSystem.TYPE_SYSTEM.LIST());
        }
        for (String key : node.keys()) {
            if (this.keys.indexOf(nodeKey + "." + key) != -1) continue;
            this.keys.add(nodeKey + "." + key);
            this.classes.add(node.get(key).type());
        }
    }

    private void flattenRelationship(Relationship rel, String relationshipKey) {
        if (this.keys.indexOf(relationshipKey + ".id") == -1) {
            this.keys.add(relationshipKey + ".id");
            this.classes.add(InternalTypeSystem.TYPE_SYSTEM.INTEGER());
            this.keys.add(relationshipKey + ".type");
            this.classes.add(InternalTypeSystem.TYPE_SYSTEM.STRING());
        }
        for (String key : rel.keys()) {
            if (this.keys.indexOf(relationshipKey + "." + key) != -1) continue;
            this.keys.add(relationshipKey + "." + key);
            this.classes.add(rel.get(key).type());
        }
    }

    private boolean flatteningTypes(StatementResult statementResult) {
        boolean result = true;
        for (Pair<String, Value> pair : statementResult.peek().fields()) {
            if (ACCEPTED_TYPES_FOR_FLATTENING.contains(pair.value().type().name())) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    protected boolean innerNext() throws SQLException {
        if (this.iterator == null) {
            throw new SQLException("ResultCursor not initialized");
        }
        this.current = !this.prefetchedRecords.isEmpty() ? this.prefetchedRecords.pop() : (this.iterator.hasNext() ? this.iterator.next() : null);
        return this.current != null;
    }

    @Override
    public void close() throws SQLException {
        if (this.iterator == null) {
            throw new SQLException("ResultCursor not initialized");
        }
        this.isClosed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return this.getStringFromValue(value);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return this.getStringFromValue(value);
    }

    private String getStringFromValue(Value value) {
        try {
            if (value.isNull()) {
                return null;
            }
            return value.asString();
        }
        catch (Uncoercible e) {
            String result = null;
            if (value instanceof IntegerValue) {
                result = ((IntegerValue)value).toString();
            } else if (value instanceof FloatValue) {
                result = ((FloatValue)value).toString();
            } else if (value instanceof NodeValue) {
                result = this.convertNodeToString(value.asNode());
            } else if (value instanceof RelationshipValue) {
                result = this.convertRelationshipToString(value.asRelationship());
            } else if (value instanceof PathValue) {
                result = this.convertPathToString(value.asPath());
            }
            return result;
        }
    }

    private String convertToJSONProperty(String key, Object value) {
        String result;
        String string = result = key == null ? "" : "\"" + key + "\":";
        if (value instanceof String) {
            result = result + "\"" + value + "\"";
        } else if (value instanceof Number) {
            result = result + value;
        } else if (value instanceof StringValue) {
            result = result + "\"" + ((StringValue)value).asString() + "\"";
        } else if (value instanceof IntegerValue) {
            result = result + Long.toString(((IntegerValue)value).asLong());
        } else if (value instanceof FloatValue) {
            result = result + Float.toString(((FloatValue)value).asFloat());
        } else if (value instanceof BooleanValue) {
            result = result + Boolean.toString(((BooleanValue)value).asBoolean());
        } else if (value instanceof ListValue) {
            result = result + "[";
            result = result + this.convertToJSONProperty(null, ((ListValue)value).asList());
            result = result + "]";
        } else if (value instanceof List) {
            String prefix = "";
            result = result + "[";
            for (Object obj : (List)value) {
                result = result + prefix + this.convertToJSONProperty(null, obj);
                prefix = ", ";
            }
            result = result + "]";
        } else if (value instanceof Iterable) {
            String prefix = "";
            result = result + "[";
            for (Object obj : (Iterable)value) {
                result = result + prefix + this.convertToJSONProperty(null, obj);
                prefix = ", ";
            }
            result = result + "]";
        }
        return result;
    }

    private String convertNodeToString(Node node) {
        String result = "{";
        result = result + this.convertToJSONProperty("id", node.id()) + ", ";
        result = result + this.convertToJSONProperty("labels", node.labels()) + (node.size() > 0 ? ", " : "");
        String prefix = "";
        for (String key : node.keys()) {
            result = result + prefix + this.convertToJSONProperty(key, node.get(key));
            prefix = ", ";
        }
        return result + "}";
    }

    private String convertRelationshipToString(Relationship rel) {
        String result = "{";
        result = result + this.convertToJSONProperty("id", rel.id()) + ", ";
        result = result + this.convertToJSONProperty("type", rel.type()) + ", ";
        result = result + this.convertToJSONProperty("startId", rel.startNodeId()) + ", ";
        result = result + this.convertToJSONProperty("endId", rel.endNodeId()) + (rel.size() > 0 ? ", " : "");
        String prefix = "";
        for (String key : rel.keys()) {
            result = result + prefix + this.convertToJSONProperty(key, rel.get(key));
            prefix = ", ";
        }
        return result + "}";
    }

    private String convertPathToString(Path path) {
        String result = "[";
        result = result + this.convertNodeToString(path.start());
        for (Path.Segment s : path) {
            result = result + ", " + this.convertRelationshipToString(s.relationship());
            result = result + ", " + this.convertNodeToString(s.end());
        }
        return result + "]";
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return !value.isNull() && value.asBoolean();
    }

    private Value fetchPropertyValue(String key, String property) throws SQLException {
        Value value;
        try {
            if ("id".equals(property)) {
                value = new IntegerValue(this.current.get(key).asEntity().id());
            } else if ("labels".equals(property)) {
                Node node = this.current.get(key).asNode();
                ArrayList<StringValue> values = new ArrayList<StringValue>();
                for (String label : node.labels()) {
                    values.add(new StringValue(label));
                }
                value = new ListValue(values.toArray(new Value[values.size()]));
            } else {
                value = "type".equals(property) ? new StringValue(this.current.get(key).asRelationship().type()) : this.current.get(key).get(property);
            }
        }
        catch (Exception e) {
            throw new SQLException("Column not present in ResultSet", e);
        }
        return value;
    }

    private Value fetchValueFromLabel(String label) throws SQLException {
        Value value;
        if (this.current.containsKey(label)) {
            value = this.current.get(label);
        } else if (this.flattened && this.keys.contains(label)) {
            String[] labelKeys = label.split("\\.");
            value = this.fetchPropertyValue(labelKeys[0], labelKeys[1]);
        } else {
            throw new SQLException("Column not present in ResultSet");
        }
        this.wasNull = value.isNull();
        return value;
    }

    private Value fetchValueFromIndex(int index) throws SQLException {
        Value value;
        if (this.flattened && index > 0 && index - 1 <= this.keys.size()) {
            String[] indexKeys = this.keys.get(index - 1).split("\\.");
            value = indexKeys.length > 1 ? this.fetchPropertyValue(indexKeys[0], indexKeys[1]) : this.current.get(this.keys.get(index - 1));
        } else if (index > 0 && index - 1 <= this.current.size()) {
            value = this.current.get(index - 1);
        } else {
            throw new SQLException("Column not present in ResultSet");
        }
        this.wasNull = value.isNull();
        return value;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return value.isNull() ? 0 : value.asInt();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return value.isNull() ? 0L : value.asLong();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkClosed();
        if (!this.keys.contains(columnLabel)) {
            throw new SQLException("Column not present in ResultSet");
        }
        return this.keys.indexOf(columnLabel) + 1;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return this.type;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return this.concurrency;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.holdability;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return !value.isNull() && value.asBoolean();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return value.isNull() ? 0 : value.asInt();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return value.isNull() ? 0L : value.asLong();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return value.isNull() ? 0.0f : value.asFloat();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return value.isNull() ? 0.0f : value.asFloat();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return value.isNull() ? (short)0 : (short)value.asInt();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return value.isNull() ? (short)0 : (short)value.asInt();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return value.isNull() ? 0.0 : value.asDouble();
    }

    @Override
    public Neo4jArray getArray(int columnIndex) throws SQLException {
        this.checkClosed();
        List<Object> list = this.fetchValueFromIndex(columnIndex).asList();
        Object obj = list.isEmpty() ? new Object() : list.get(0);
        return new ListArray(list, Neo4jArray.getObjectType(obj));
    }

    @Override
    public Neo4jArray getArray(String columnLabel) throws SQLException {
        this.checkClosed();
        List<Object> list = this.fetchValueFromLabel(columnLabel).asList();
        Object obj = list.isEmpty() ? new Object() : list.get(0);
        return new ListArray(list, Neo4jArray.getObjectType(obj));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return value.isNull() ? 0.0 : value.asDouble();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    private Object convertObject(Object value) {
        Object converted = value;
        if (value instanceof Point) {
            converted = this.pointToMap((Point)((Object)value));
        }
        if (value instanceof List) {
            converted = this.convertList((List)((Object)value));
        }
        if (value instanceof ZonedDateTime) {
            return this.zonedDateTimeToTimestamp((ZonedDateTime)((Object)value));
        }
        if (value instanceof LocalDateTime) {
            return this.localDateTimeToTimestamp((LocalDateTime)((Object)value));
        }
        if (value instanceof LocalDate) {
            return this.localDateToDate((LocalDate)((Object)value));
        }
        if (value instanceof OffsetTime) {
            return this.offsetTimeToTime((OffsetTime)((Object)value));
        }
        if (value instanceof LocalTime) {
            return this.localTimeToTime((LocalTime)((Object)value));
        }
        if (value instanceof InternalIsoDuration) {
            return this.durationToMap((InternalIsoDuration)((Object)value));
        }
        return converted;
    }

    private List convertList(List list) {
        ArrayList<Object> converted = new ArrayList<Object>(list.size());
        for (Object o : list) {
            converted.add(this.convertObject(o));
        }
        return converted;
    }

    private Map<String, Object> pointToMap(Point point) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("srid", point.srid());
        map.put("x", point.x());
        map.put("y", point.y());
        switch (point.srid()) {
            case 7203: {
                map.put("crs", "cartesian");
                break;
            }
            case 9157: {
                map.put("crs", "cartesian-3d");
                map.put("z", point.z());
                break;
            }
            case 4326: {
                map.put("crs", "wgs-84");
                map.put("longitude", point.x());
                map.put("latitude", point.y());
                break;
            }
            case 4979: {
                map.put("crs", "wgs-84-3d");
                map.put("longitude", point.x());
                map.put("latitude", point.y());
                map.put("height", point.z());
                map.put("z", point.z());
            }
        }
        return map;
    }

    private Map<String, Object> convertFields(Map<String, Object> fields) {
        HashMap<String, Object> converted = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> entrySet = fields.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            converted.put(entry.getKey(), this.convertObject(entry.getValue()));
        }
        return converted;
    }

    private Object generateObject(Object obj) {
        if (obj instanceof Node) {
            Node node = (Node)obj;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("_id", node.id());
            map.put("_labels", node.labels());
            map.putAll(this.convertFields(node.asMap()));
            return map;
        }
        if (obj instanceof Relationship) {
            Relationship rel = (Relationship)obj;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("_id", rel.id());
            map.put("_type", rel.type());
            map.put("_startId", rel.startNodeId());
            map.put("_endId", rel.endNodeId());
            map.putAll(this.convertFields(rel.asMap()));
            return map;
        }
        if (obj instanceof Path) {
            Path path = (Path)obj;
            ArrayList<Object> list = new ArrayList<Object>(path.length());
            list.add(this.generateObject(path.start()));
            for (Path.Segment segment : path) {
                list.add(this.generateObject(segment.relationship()));
                list.add(this.generateObject(segment.end()));
            }
            return list;
        }
        return this.convertObject(obj);
    }

    private Map<String, Object> durationToMap(InternalIsoDuration obj) {
        HashMap<String, Object> converted = new HashMap<String, Object>(16);
        converted.put("duration", obj.toString());
        converted.put("months", obj.months());
        converted.put("days", obj.days());
        converted.put("seconds", obj.seconds());
        converted.put("nanoseconds", obj.nanoseconds());
        return converted;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        Object obj = this.fetchValueFromIndex(columnIndex).asObject();
        return this.generateObject(obj);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkClosed();
        Object obj = this.fetchValueFromLabel(columnLabel).asObject();
        return this.generateObject(obj);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        try {
            return this.getObject(type, () -> this.fetchValueFromLabel(columnLabel), () -> this.getObject(columnLabel));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private boolean isNeo4jDatatype(Class type) {
        return ObjectValueAdapter.class.isAssignableFrom(type);
    }

    private <T> T getObject(Class<T> type, Callable fetch, Callable getObject) throws Exception {
        T ret;
        this.checkClosed();
        if (type == null) {
            throw new SQLException("Type to cast cannot be null");
        }
        if (this.isNeo4jDatatype(type)) {
            return (T)fetch.call();
        }
        if (type == ZonedDateTime.class) {
            DateTimeValue value = (DateTimeValue)fetch.call();
            return (T)value.asZonedDateTime();
        }
        if (type == LocalDateTime.class) {
            LocalDateTimeValue value = (LocalDateTimeValue)fetch.call();
            return (T)value.asLocalDateTime();
        }
        if (type == IsoDuration.class) {
            DurationValue value = (DurationValue)fetch.call();
            return (T)value.asIsoDuration();
        }
        if (type == LocalDate.class) {
            DateValue value = (DateValue)fetch.call();
            return (T)value.asLocalDate();
        }
        if (type == LocalTime.class) {
            LocalTimeValue value = (LocalTimeValue)fetch.call();
            return (T)value.asLocalTime();
        }
        if (type == OffsetTime.class) {
            TimeValue value = (TimeValue)fetch.call();
            return (T)value.asOffsetTime();
        }
        if (type == Point.class) {
            PointValue value = (PointValue)fetch.call();
            return (T)value.asPoint();
        }
        Object obj = getObject.call();
        try {
            ret = ObjectConverter.convert(obj, type);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return ret;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        try {
            return this.getObject(type, () -> this.fetchValueFromIndex(columnIndex), () -> this.getObject(columnIndex));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        Object ret;
        this.checkClosed();
        Object obj = this.getObject(columnLabel);
        String fromClass = obj.getClass().getCanonicalName();
        Class<?> toClass = map.get(fromClass);
        if (toClass == null) {
            throw new SQLException(String.format("Mapping for class: %s not found", fromClass));
        }
        try {
            ret = ObjectConverter.convert(obj, toClass);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return ret;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        Object ret;
        this.checkClosed();
        Object obj = this.getObject(columnIndex);
        try {
            ret = ObjectConverter.convert(obj, map.get(obj.getClass().toString()));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return ret;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    private Time valueToTime(Value value) {
        return this.valueToTime(value, Calendar.getInstance());
    }

    private Time valueToTime(Value value, Calendar cal) {
        if (value.isNull()) {
            return null;
        }
        if (value instanceof TimeValue) {
            ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(cal.get(15) / 1000);
            TimeValue timeValue = (TimeValue)value;
            OffsetTime offsetTime = timeValue.asOffsetTime().withOffsetSameInstant(zoneOffset);
            return this.offsetTimeToTime(offsetTime);
        }
        if (value instanceof LocalTimeValue) {
            return this.localTimeToTime(((LocalTimeValue)value).asLocalTime());
        }
        return null;
    }

    private Time localTimeToTime(LocalTime localTime) {
        Time time = Time.valueOf(localTime);
        time.setTime(time.getTime() + (long)localTime.getNano() / 1000000L);
        return time;
    }

    private Time offsetTimeToTime(OffsetTime offsetTime) {
        return this.localTimeToTime(offsetTime.toLocalTime());
    }

    private Date valueToDate(Value value) {
        if (value.isNull()) {
            return null;
        }
        if (value instanceof DateValue) {
            return this.localDateToDate(((DateValue)value).asLocalDate());
        }
        return null;
    }

    private Date localDateToDate(LocalDate localDate) {
        return Date.valueOf(localDate);
    }

    private Timestamp valueToTimestamp(Value value) {
        return this.valueToTimestamp(value, ZoneId.systemDefault());
    }

    private Timestamp valueToTimestamp(Value value, ZoneId zone) {
        if (value.isNull()) {
            return null;
        }
        if (value instanceof DateTimeValue) {
            return this.zonedDateTimeToTimestamp(value.asZonedDateTime().withZoneSameInstant(zone));
        }
        if (value instanceof LocalDateTimeValue) {
            return this.localDateTimeToTimestamp(value.asLocalDateTime());
        }
        return null;
    }

    private Timestamp localDateTimeToTimestamp(LocalDateTime ldt) {
        return Timestamp.valueOf(ldt);
    }

    private Timestamp zonedDateTimeToTimestamp(ZonedDateTime zdt) {
        return new Timestamp(zdt.toInstant().toEpochMilli());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return this.valueToTimestamp(value);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return this.valueToTimestamp(value);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return this.valueToDate(value);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return this.valueToDate(value);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return this.valueToTime(value);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return this.valueToTime(value);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return this.valueToTimestamp(value, cal.getTimeZone().toZoneId());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return this.valueToTimestamp(value, cal.getTimeZone().toZoneId());
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromIndex(columnIndex);
        return this.valueToTime(value, cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        this.checkClosed();
        Value value = this.fetchValueFromLabel(columnLabel);
        return this.valueToTime(value, cal);
    }
}

