/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.summary.SummaryCounters;
import org.neo4j.jdbc.Neo4jStatement;
import org.neo4j.jdbc.bolt.BoltNeo4jConnection;
import org.neo4j.jdbc.bolt.BoltNeo4jResultSet;
import org.neo4j.jdbc.bolt.BoltNeo4jUtils;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jConnectionImpl;
import org.neo4j.jdbc.utils.Neo4jInvocationHandler;

public class BoltNeo4jStatement
extends Neo4jStatement {
    private BoltNeo4jStatement(BoltNeo4jConnectionImpl connection, int ... rsParams) {
        super(connection);
        this.resultSetParams = rsParams;
        this.batchStatements = new ArrayList();
    }

    public static Statement newInstance(boolean debug, BoltNeo4jConnectionImpl connection, int ... rsParams) {
        BoltNeo4jStatement statement = new BoltNeo4jStatement(connection, rsParams);
        ((Neo4jStatement)statement).setDebug(debug);
        return (Statement)Proxy.newProxyInstance(BoltNeo4jStatement.class.getClassLoader(), new Class[]{Statement.class}, (InvocationHandler)new Neo4jInvocationHandler(statement, debug));
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        StatementResult result = this.executeInternal(sql);
        this.currentResultSet = BoltNeo4jResultSet.newInstance(this.hasDebug(), this, result, this.resultSetParams);
        this.currentUpdateCount = -1;
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        StatementResult result = this.executeInternal(sql);
        SummaryCounters stats = result.consume().counters();
        this.currentUpdateCount = BoltNeo4jUtils.calculateUpdateCount(stats);
        this.currentResultSet = null;
        return this.currentUpdateCount;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        StatementResult result = this.executeInternal(sql);
        boolean hasResultSet = false;
        if (result != null) {
            hasResultSet = this.hasResultSet(sql);
            if (hasResultSet) {
                this.currentResultSet = BoltNeo4jResultSet.newInstance(this.hasDebug(), this, result, this.resultSetParams);
                this.currentUpdateCount = -1;
            } else {
                this.currentResultSet = null;
                try {
                    SummaryCounters stats = result.consume().counters();
                    this.currentUpdateCount = BoltNeo4jUtils.calculateUpdateCount(stats);
                }
                catch (Exception e) {
                    throw new SQLException(e);
                }
            }
        }
        return hasResultSet;
    }

    private StatementResult executeInternal(String statement) throws SQLException {
        this.checkClosed();
        try {
            Transaction transaction = ((BoltNeo4jConnection)((Object)this.getConnection())).getTransaction();
            StatementResult result = transaction.run(statement);
            if (this.getConnection().getAutoCommit()) {
                ((BoltNeo4jConnection)((Object)this.getConnection())).doCommit();
            }
            return result;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    private boolean hasResultSet(String sql) {
        return sql != null && sql.toLowerCase().contains("return ");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        int[] result = new int[]{};
        try {
            for (String query : this.batchStatements) {
                StatementResult res = ((BoltNeo4jConnection)((Object)this.connection)).getTransaction().run(query);
                SummaryCounters count = res.consume().counters();
                result = Arrays.copyOf(result, result.length + 1);
                result[result.length - 1] = count.nodesCreated() + count.nodesDeleted();
                if (!this.connection.getAutoCommit()) continue;
                ((BoltNeo4jConnection)((Object)this.connection)).doCommit();
            }
        }
        catch (Exception e) {
            throw new BatchUpdateException(result, (Throwable)e);
        }
        return result;
    }
}

