/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.boltrouting;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jDriverImpl;

public class BoltRoutingNeo4jDriver
extends BoltNeo4jDriverImpl {
    public static final String JDBC_BOLT_ROUTING_PREFIX = "bolt\\+routing";
    public static final String ROUTING_CONTEXT = "routing";
    public static final String ALTERNATIVE_SERVERS = "servers";
    public static final String BOOKMARK = "bookmark";
    public static final String LIST_SEPARATOR = ";";
    public static final String CUSTOM_ROUTING_POLICY_SEPARATOR = "&";

    public BoltRoutingNeo4jDriver() throws SQLException {
        super(JDBC_BOLT_ROUTING_PREFIX);
    }

    @Override
    protected Driver getDriver(List<URI> routingUris, Config config, AuthToken authToken) throws URISyntaxException {
        return GraphDatabase.routingDriver(routingUris, authToken, config);
    }

    @Override
    protected Properties getRoutingContext(String url, Properties properties) {
        Properties props = new Properties();
        if (url.matches("^bolt\\+routing.*") && properties.containsKey(ROUTING_CONTEXT)) {
            List<String> routingParams = null;
            routingParams = properties.get(ROUTING_CONTEXT) instanceof String ? Arrays.asList(properties.getProperty(ROUTING_CONTEXT)) : (List<String>)properties.get(ROUTING_CONTEXT);
            for (String routingParam : routingParams) {
                if (routingParam.startsWith(ALTERNATIVE_SERVERS)) {
                    props.put(ALTERNATIVE_SERVERS, routingParam.substring(ALTERNATIVE_SERVERS.length() + 1));
                    continue;
                }
                props.put(ROUTING_CONTEXT, routingParam);
            }
        }
        return props;
    }

    @Override
    protected String addRoutingPolicy(String url, Properties properties) {
        String boltUrl = url;
        if (boltUrl.matches("^bolt\\+routing.*") && properties.containsKey(ROUTING_CONTEXT)) {
            boltUrl = boltUrl + "?" + properties.getProperty(ROUTING_CONTEXT).replaceAll(LIST_SEPARATOR, CUSTOM_ROUTING_POLICY_SEPARATOR);
        }
        return boltUrl;
    }

    @Override
    protected List<URI> buildRoutingUris(String boltUrl, Properties properties) throws URISyntaxException {
        String[] servers;
        URI firstServer = new URI(boltUrl);
        ArrayList<URI> routingUris = new ArrayList<URI>();
        for (String server : servers = firstServer.getAuthority().split("\\,")) {
            routingUris.add(new URI(firstServer.getScheme(), server, firstServer.getPath(), firstServer.getQuery(), firstServer.getFragment()));
        }
        if (properties.containsKey(ALTERNATIVE_SERVERS)) {
            String[] alternativeServerList;
            String alternativeServers = properties.getProperty(ALTERNATIVE_SERVERS);
            for (String alternativeServer : alternativeServerList = alternativeServers.split("\\;")) {
                routingUris.add(new URI(firstServer.getScheme(), alternativeServer, firstServer.getPath(), firstServer.getQuery(), firstServer.getFragment()));
            }
        }
        return routingUris;
    }

    static {
        try {
            BoltRoutingNeo4jDriver driver = new BoltRoutingNeo4jDriver();
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

