/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.neo4j.jdbc.InstanceFactory;
import org.neo4j.jdbc.Neo4jDriver;
import org.neo4j.jdbc.http.HttpNeo4jConnection;

public class HttpDriver
extends Neo4jDriver {
    public static final String JDBC_HTTP_PREFIX = "http(s)*";

    public HttpDriver() throws SQLException {
        super(JDBC_HTTP_PREFIX);
    }

    @Override
    public Connection connect(String url, Properties params) throws SQLException {
        Connection connection = null;
        try {
            if (this.acceptsURL(url)) {
                URL neo4jUrl = new URL(url.replace("jdbc:neo4j:", "").replaceAll("^(http(s)*:)([^/])", "$1//$2"));
                Properties props = this.parseUrlProperties(url, params);
                String host = neo4jUrl.getHost();
                Boolean secure = Boolean.FALSE;
                int port = 7474;
                if ("https".equals(neo4jUrl.getProtocol())) {
                    port = 7473;
                    secure = Boolean.TRUE;
                }
                if (neo4jUrl.getPort() > 0) {
                    port = neo4jUrl.getPort();
                }
                connection = InstanceFactory.debug(new HttpNeo4jConnection(host, port, secure, props, url));
            }
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
        return connection;
    }

    static {
        try {
            HttpDriver driver = new HttpDriver();
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

