/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.http;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.neo4j.jdbc.InstanceFactory;
import org.neo4j.jdbc.Loggable;
import org.neo4j.jdbc.Neo4jDatabaseMetaData;
import org.neo4j.jdbc.http.HttpNeo4jDatabaseMetaData;
import org.neo4j.jdbc.http.HttpNeo4jPreparedStatement;
import org.neo4j.jdbc.http.HttpNeo4jStatement;
import org.neo4j.jdbc.http.driver.CypherExecutor;
import org.neo4j.jdbc.http.driver.Neo4jResponse;
import org.neo4j.jdbc.http.driver.Neo4jStatement;
import org.neo4j.jdbc.impl.Neo4jConnectionImpl;
import org.neo4j.jdbc.utils.ExceptionBuilder;
import org.neo4j.jdbc.utils.Neo4jJdbcRuntimeException;
import org.neo4j.jdbc.utils.TimeLimitedCodeBlock;

public class HttpNeo4jConnection
extends Neo4jConnectionImpl
implements Loggable {
    CypherExecutor executor;
    private boolean isClosed = false;
    private boolean debug = false;
    private int debugLevel;

    public HttpNeo4jConnection(String host, Integer port, Boolean secure, Properties properties, String url) throws SQLException {
        super(properties, url, 2);
        this.executor = new CypherExecutor(host, port, secure, properties);
    }

    public Neo4jResponse executeQueries(List<String> queries, List<Map<String, Object>> parameters, Boolean stats) throws SQLException {
        this.checkClosed();
        if (queries.size() != parameters.size()) {
            throw new SQLException("Query and parameter list haven't the same cardinality");
        }
        ArrayList<Neo4jStatement> neo4jStatements = new ArrayList<Neo4jStatement>();
        for (int i = 0; i < queries.size(); ++i) {
            String query = queries.get(i);
            Map<String, Object> params = parameters.get(i);
            this.checkReadOnly(query);
            neo4jStatements.add(new Neo4jStatement(query, params, stats));
        }
        return this.executor.executeQueries(neo4jStatements);
    }

    public Neo4jResponse executeQuery(String query, Map<String, Object> parameters, Boolean stats) throws SQLException {
        this.checkClosed();
        this.checkReadOnly(query);
        return this.executor.executeQuery(new Neo4jStatement(query, parameters, stats));
    }

    @Override
    public Neo4jDatabaseMetaData getMetaData() throws SQLException {
        return new HttpNeo4jDatabaseMetaData(this);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.executor.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.executor.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        this.checkAutoCommit();
        this.executor.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        this.checkAutoCommit();
        this.executor.rollback();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw ExceptionBuilder.buildUnsupportedOperationException();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return InstanceFactory.debug(new HttpNeo4jStatement(this));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return InstanceFactory.debug(new HttpNeo4jStatement(this));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return InstanceFactory.debug(new HttpNeo4jStatement(this));
    }

    @Override
    public PreparedStatement prepareStatement(String cypher) throws SQLException {
        this.checkClosed();
        return InstanceFactory.debug(new HttpNeo4jPreparedStatement(this, cypher));
    }

    @Override
    public PreparedStatement prepareStatement(String cypher, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return InstanceFactory.debug(new HttpNeo4jPreparedStatement(this, cypher));
    }

    @Override
    public PreparedStatement prepareStatement(String cypher, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return InstanceFactory.debug(new HttpNeo4jPreparedStatement(this, cypher));
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void close() throws SQLException {
        if (!this.getAutoCommit() && this.executor.getOpenTransactionId() > 0) {
            this.executor.rollback();
        }
        this.executor.close();
        this.isClosed = true;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout can't be less than zero");
        }
        if (this.isClosed()) {
            return false;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    HttpNeo4jConnection.this.executor.executeQuery(new Neo4jStatement("RETURN 1", null, null));
                }
                catch (Exception e) {
                    throw new Neo4jJdbcRuntimeException(e);
                }
            }
        };
        try {
            TimeLimitedCodeBlock.runWithTimeout(r, timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean hasDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void setDebugLevel(int level) {
        this.debugLevel = level;
    }

    @Override
    public int getDebugLevel() {
        return this.debugLevel;
    }
}

