/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.http;

import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.neo4j.jdbc.Loggable;
import org.neo4j.jdbc.Neo4jParameterMetaData;
import org.neo4j.jdbc.Neo4jPreparedStatement;
import org.neo4j.jdbc.Neo4jResultSetMetaData;
import org.neo4j.jdbc.http.HttpNeo4jConnection;
import org.neo4j.jdbc.http.HttpNeo4jParameterMetaData;
import org.neo4j.jdbc.http.HttpNeo4jResultSet;
import org.neo4j.jdbc.http.HttpNeo4jResultSetMetaData;
import org.neo4j.jdbc.http.driver.Neo4jResponse;

public class HttpNeo4jPreparedStatement
extends Neo4jPreparedStatement
implements Loggable {
    public HttpNeo4jPreparedStatement(HttpNeo4jConnection httpConnection, String cypher) {
        super(httpConnection, cypher);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        this.execute();
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkClosed();
        this.execute();
        return this.currentUpdateCount;
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkClosed();
        Neo4jResponse response = ((HttpNeo4jConnection)this.getConnection()).executeQuery(this.statement, this.parameters, Boolean.TRUE);
        if (response.hasErrors()) {
            throw new SQLException(response.displayErrors());
        }
        this.currentUpdateCount = response.getFirstResult().getUpdateCount();
        boolean hasResultSets = response.hasResultSets();
        this.currentResultSet = hasResultSets ? new HttpNeo4jResultSet(this, response.getFirstResult()) : null;
        return hasResultSets;
    }

    @Override
    public Neo4jResultSetMetaData getMetaData() throws SQLException {
        return new HttpNeo4jResultSetMetaData(((HttpNeo4jResultSet)this.currentResultSet).result);
    }

    @Override
    public Neo4jParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        return new HttpNeo4jParameterMetaData(this);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        ArrayList<String> queries = new ArrayList<String>();
        for (int i = 0; i < this.batchParameters.size(); ++i) {
            queries.add(this.statement);
        }
        Neo4jResponse response = ((HttpNeo4jConnection)this.getConnection()).executeQueries(queries, this.batchParameters, Boolean.TRUE);
        int[] result = new int[response.getResults().size()];
        for (int i = 0; i < response.getResults().size(); ++i) {
            result[i] = response.getResults().get(i).getUpdateCount();
        }
        if (response.getErrors() != null && response.getErrors().size() > 0) {
            throw new BatchUpdateException(result, response.getErrors().get(0).getCause());
        }
        if (response.getResults().size() != this.batchParameters.size()) {
            throw new BatchUpdateException("Result size doesn't match queries size", result);
        }
        return result;
    }
}

