/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.neo4j.jdbc.utils.Neo4jJdbcRuntimeException;

public class TimeLimitedCodeBlock {
    private TimeLimitedCodeBlock() {
    }

    public static void runWithTimeout(Runnable runnable, long timeout, TimeUnit timeUnit) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(runnable);
        executor.shutdown();
        try {
            if (timeout == 0L) {
                future.get();
            } else {
                future.get(timeout, timeUnit);
            }
        }
        catch (Exception e) {
            future.cancel(true);
            throw new Neo4jJdbcRuntimeException(e);
        }
    }
}

