/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.driver;

import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.driver.ObjectMapperBasedParameterConversion;
import org.neo4j.ogm.driver.ParameterConversion;
import org.neo4j.ogm.spi.CypherModificationProvider;
import org.neo4j.ogm.transaction.TransactionManager;

public abstract class AbstractConfigurableDriver
implements Driver {
    public static final ParameterConversion CONVERT_ALL_PARAMETERS_CONVERSION = ObjectMapperBasedParameterConversion.INSTANCE;
    private final ServiceLoader<CypherModificationProvider> cypherModificationProviderLoader = ServiceLoader.load(CypherModificationProvider.class);
    protected Configuration configuration;
    protected TransactionManager transactionManager;
    protected final Supplier<Map<String, Object>> customPropertiesSupplier;
    private volatile Function<String, String> cypherModification;

    public AbstractConfigurableDriver() {
        this.customPropertiesSupplier = this::getConfigurationProperties;
    }

    protected AbstractConfigurableDriver(Supplier<Map<String, Object>> customPropertiesSupplier) {
        this.customPropertiesSupplier = customPropertiesSupplier;
    }

    @Override
    public void configure(Configuration config) {
        this.configuration = config;
    }

    @Override
    public void setTransactionManager(TransactionManager transactionManager) {
        assert (transactionManager != null);
        this.transactionManager = transactionManager;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Function<String, String> getCypherModification() {
        Function<String, String> loadedCypherModification = this.cypherModification;
        if (loadedCypherModification == null) {
            AbstractConfigurableDriver abstractConfigurableDriver = this;
            synchronized (abstractConfigurableDriver) {
                loadedCypherModification = this.cypherModification;
                if (loadedCypherModification == null) {
                    loadedCypherModification = this.cypherModification = this.loadCypherModifications();
                }
            }
        }
        return loadedCypherModification;
    }

    private Map<String, Object> getConfigurationProperties() {
        if (this.configuration == null) {
            throw new IllegalStateException("Driver is not configured and cannot load Cypher modifications.");
        }
        return this.configuration.getCustomProperties();
    }

    private Function<String, String> loadCypherModifications() {
        Map<String, Object> configurationProperties = this.customPropertiesSupplier.get();
        this.cypherModificationProviderLoader.reload();
        return StreamSupport.stream(this.cypherModificationProviderLoader.spliterator(), false).sorted(Comparator.comparing(CypherModificationProvider::getOrder)).map(provider -> provider.getCypherModification(configurationProperties)).reduce(Function.identity(), Function::andThen, Function::andThen);
    }
}

