/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.compiler.SrcTargetKey;
import org.neo4j.ogm.context.DirectedRelationship;
import org.neo4j.ogm.context.EntityMapper;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.context.TransientRelationship;
import org.neo4j.ogm.context.WriteProtectionTarget;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.cypher.compiler.MultiStatementCypherCompiler;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;
import org.neo4j.ogm.cypher.compiler.PropertyContainerBuilder;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.utils.ClassUtils;
import org.neo4j.ogm.utils.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityGraphMapper
implements EntityMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityGraphMapper.class);
    private final MetaData metaData;
    private final MappingContext mappingContext;
    private final Compiler compiler = new MultiStatementCypherCompiler();
    private Optional<BiFunction<WriteProtectionTarget, Class<?>, Predicate<Object>>> optionalWriteProtectionSupplier = Optional.empty();

    public EntityGraphMapper(MetaData metaData, MappingContext mappingContext) {
        this.metaData = metaData;
        this.mappingContext = mappingContext;
    }

    public void addWriteProtection(BiFunction<WriteProtectionTarget, Class<?>, Predicate<Object>> writeProtectionSupplier) {
        this.optionalWriteProtectionSupplier = Optional.ofNullable(writeProtectionSupplier);
    }

    @Override
    public CompileContext map(Object entity) {
        return this.map(entity, -1);
    }

    @Override
    public CompileContext map(Object entity, int horizon) {
        if (entity == null) {
            throw new NullPointerException("Cannot map null object");
        }
        for (MappedRelationship mappedRelationship : this.mappingContext.getRelationships()) {
            LOGGER.debug("context-init: (${})-[:{}]->(${})", new Object[]{mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
            this.compiler.context().registerRelationship(mappedRelationship);
        }
        LOGGER.debug("context initialised with {} relationships", (Object)this.mappingContext.getRelationships().size());
        if (this.isRelationshipEntity(entity)) {
            ClassInfo reInfo = this.metaData.classInfo(entity);
            Object startNode = reInfo.getStartNodeReader().read(entity);
            if (startNode == null) {
                throw new RuntimeException("@StartNode of relationship entity may not be null");
            }
            Object endNode = reInfo.getEndNodeReader().read(entity);
            if (endNode == null) {
                throw new RuntimeException("@EndNode of relationship entity may not be null");
            }
            NodeBuilder startNodeBuilder = this.mapEntity(startNode, horizon, this.compiler);
            NodeBuilder endNodeBuilder = this.mapEntity(endNode, horizon, this.compiler);
            if (!this.compiler.context().visitedRelationshipEntity(this.mappingContext.nativeId(entity))) {
                AnnotationInfo annotationInfo = reInfo.annotationsInfo().get(RelationshipEntity.class);
                String relationshipType = annotationInfo.get("type", null);
                DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, "OUTGOING");
                RelationshipBuilder relationshipBuilder = this.getRelationshipBuilder(this.compiler, entity, directedRelationship, false);
                this.updateRelationshipEntity(this.compiler.context(), entity, relationshipBuilder, reInfo);
                Long srcIdentity = this.mappingContext.nativeId(startNode);
                Long tgtIdentity = this.mappingContext.nativeId(endNode);
                RelationshipNodes relNodes = new RelationshipNodes(srcIdentity, tgtIdentity, startNode.getClass(), endNode.getClass());
                this.updateRelationship(this.compiler.context(), startNodeBuilder, endNodeBuilder, relationshipBuilder, relNodes);
            }
        } else {
            this.mapEntity(entity, horizon, this.compiler);
        }
        this.deleteObsoleteRelationships(this.compiler);
        return this.compiler.context();
    }

    @Override
    public CompileContext compileContext() {
        return this.compiler.context();
    }

    private void deleteObsoleteRelationships(Compiler compiler) {
        CompileContext context = compiler.context();
        Iterator<MappedRelationship> mappedRelationshipIterator = this.mappingContext.getRelationships().iterator();
        while (mappedRelationshipIterator.hasNext()) {
            ClassInfo classInfo;
            MappedRelationship mappedRelationship = mappedRelationshipIterator.next();
            if (context.removeRegisteredRelationship(mappedRelationship)) continue;
            LOGGER.debug("context-del: {}", (Object)mappedRelationship);
            RelationshipBuilder builder = compiler.unrelate(mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId(), mappedRelationship.getRelationshipId());
            Object entity = this.mappingContext.getRelationshipEntity(mappedRelationship.getRelationshipId());
            if (entity != null && (classInfo = this.metaData.classInfo(entity)).hasVersionField()) {
                FieldInfo field = classInfo.getVersionField();
                builder.setVersionProperty(field.propertyName(), (Long)field.read(entity));
            }
            this.clearRelatedObjects(mappedRelationship.getStartNodeId());
            this.clearRelatedObjects(mappedRelationship.getEndNodeId());
            mappedRelationshipIterator.remove();
        }
    }

    private void clearRelatedObjects(Long node) {
        for (MappedRelationship mappedRelationship : this.mappingContext.getRelationships()) {
            if (mappedRelationship.getStartNodeId() != node.longValue() && mappedRelationship.getEndNodeId() != node.longValue()) continue;
            Object dirty = this.mappingContext.getNodeEntity(mappedRelationship.getEndNodeId());
            if (dirty != null) {
                LOGGER.debug("flushing end node of: (${})-[:{}]->(${})", new Object[]{mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
                this.mappingContext.removeNodeEntity(dirty, true);
            }
            if ((dirty = this.mappingContext.getNodeEntity(mappedRelationship.getStartNodeId())) == null) continue;
            LOGGER.debug("flushing start node of: (${})-[:{}]->(${})", new Object[]{mappedRelationship.getStartNodeId(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
            this.mappingContext.removeNodeEntity(dirty, true);
        }
    }

    private NodeBuilder mapEntity(Object entity, int horizon, Compiler compiler) {
        CompileContext context = compiler.context();
        ClassInfo classInfo = this.metaData.classInfo(entity);
        if (classInfo == null) {
            return null;
        }
        if (context.visited(entity, horizon)) {
            LOGGER.debug("already visited: {}", entity);
            return context.visitedNode(entity);
        }
        NodeBuilder nodeBuilder = context.visitedNode(entity);
        if (nodeBuilder == null) {
            nodeBuilder = this.newNodeBuilder(compiler, entity, horizon);
            if (!this.isWriteProtected(WriteProtectionTarget.PROPERTIES, entity)) {
                this.updateNode(entity, context, nodeBuilder);
            }
        }
        if (nodeBuilder != null) {
            if (horizon != 0) {
                this.mapEntityReferences(entity, nodeBuilder, horizon - 1, compiler);
            } else {
                LOGGER.debug("at horizon: {} ", entity);
            }
        }
        return nodeBuilder;
    }

    private boolean isWriteProtected(WriteProtectionTarget mode, Object target) {
        return this.optionalWriteProtectionSupplier.map((? super T supplier) -> (Predicate)supplier.apply(mode, target.getClass())).map((? super T p) -> p.test(target)).orElse(false);
    }

    private void updateNode(Object entity, CompileContext context, NodeBuilder nodeBuilder) {
        if (this.mappingContext.isDirty(entity)) {
            LOGGER.debug("{} has changed", entity);
            context.register(entity);
            ClassInfo classInfo = this.metaData.classInfo(entity);
            this.updateFieldsOnBuilder(entity, nodeBuilder, classInfo);
        } else {
            context.deregister(nodeBuilder);
            LOGGER.debug("{}, has not changed", entity);
        }
    }

    private NodeBuilder newNodeBuilder(Compiler compiler, Object entity, int horizon) {
        NodeBuilder nodeBuilder;
        String primaryIndex;
        ClassInfo classInfo = this.metaData.classInfo(entity);
        if (classInfo == null) {
            return null;
        }
        CompileContext context = compiler.context();
        Long id = this.mappingContext.nativeId(entity);
        Collection<String> labels = EntityUtils.labels(entity, this.metaData);
        String string = primaryIndex = classInfo.primaryIndexField() != null ? classInfo.primaryIndexField().property() : null;
        if (id < 0L) {
            nodeBuilder = compiler.newNode(id).addLabels(labels).setPrimaryIndex(primaryIndex);
            context.registerNewObject(id, entity);
        } else {
            nodeBuilder = compiler.existingNode(Long.valueOf(id.toString()));
            nodeBuilder.addLabels(labels).setPrimaryIndex(primaryIndex);
            this.mappingContext.getSnapshotOf(entity).ifPresent(snapshot -> {
                NodeBuilder cfr_ignored_0 = (NodeBuilder)nodeBuilder.setPreviousDynamicLabels(snapshot.getDynamicLabels()).setPreviousCompositeProperties(snapshot.getDynamicCompositeProperties());
            });
        }
        LOGGER.debug("visiting: {}", entity);
        context.visit(entity, nodeBuilder, horizon);
        return nodeBuilder;
    }

    private void mapEntityReferences(Object entity, NodeBuilder nodeBuilder, int horizon, Compiler compiler) {
        LOGGER.debug("mapping references declared by: {} ", entity);
        ClassInfo srcInfo = this.metaData.classInfo(entity);
        Long srcIdentity = this.mappingContext.nativeId(entity);
        for (FieldInfo reader : srcInfo.relationshipFields()) {
            ClassInfo relatedObjectClassInfo;
            ClassInfo declaredObjectInfo;
            boolean cleared;
            String relationshipType = reader.relationshipType();
            String relationshipDirection = reader.relationshipDirection();
            Class<?> startNodeType = srcInfo.getUnderlyingClass();
            Class<?> endNodeType = ClassUtils.getType(reader.typeDescriptor());
            DirectedRelationship directedRelationship = new DirectedRelationship(relationshipType, relationshipDirection);
            CompileContext context = compiler.context();
            if (srcIdentity >= 0L && !(cleared = this.clearContextRelationships(context, srcIdentity, endNodeType, directedRelationship))) {
                LOGGER.debug("this relationship is already being managed: {}-{}-{}-()", new Object[]{entity, relationshipType, relationshipDirection});
                continue;
            }
            Object relatedObject = reader.read(entity);
            if (relatedObject == null) continue;
            if (this.isRelationshipEntity(relatedObject) && (declaredObjectInfo = this.metaData.classInfo(relationshipType)).isAbstract() && !(relatedObjectClassInfo = this.metaData.classInfo(relatedObject)).neo4jName().equals(directedRelationship.type())) {
                directedRelationship = new DirectedRelationship(relatedObjectClassInfo.neo4jName(), directedRelationship.direction());
                relationshipType = directedRelationship.type();
            }
            LOGGER.debug("mapping reference type: {}", (Object)relationshipType);
            RelationshipNodes relNodes = new RelationshipNodes(entity, relatedObject, startNodeType, endNodeType);
            relNodes.sourceId = srcIdentity;
            Boolean mapBothWays = null;
            if (relatedObject instanceof Iterable) {
                for (Object tgtObject : (Iterable)relatedObject) {
                    if (mapBothWays == null) {
                        mapBothWays = this.bothWayMappingRequired(entity, relationshipType, tgtObject, relationshipDirection);
                    }
                    relNodes.target = tgtObject;
                    this.link(compiler, directedRelationship, nodeBuilder, horizon, mapBothWays, relNodes);
                }
                continue;
            }
            if (relatedObject.getClass().isArray()) {
                for (Object tgtObject : (Object[])relatedObject) {
                    if (mapBothWays == null) {
                        mapBothWays = this.bothWayMappingRequired(entity, relationshipType, tgtObject, relationshipDirection);
                    }
                    relNodes.target = tgtObject;
                    this.link(compiler, directedRelationship, nodeBuilder, horizon, mapBothWays, relNodes);
                }
                continue;
            }
            mapBothWays = this.bothWayMappingRequired(entity, relationshipType, relatedObject, relationshipDirection);
            this.link(compiler, directedRelationship, nodeBuilder, horizon, mapBothWays, relNodes);
        }
    }

    private boolean clearContextRelationships(CompileContext context, Long identity, Class endNodeType, DirectedRelationship directedRelationship) {
        if (directedRelationship.direction().equals("INCOMING")) {
            LOGGER.debug("context-del: ({})<-[:{}]-()", (Object)identity, (Object)directedRelationship.type());
            return context.deregisterIncomingRelationships(identity, directedRelationship.type(), endNodeType, this.metaData.isRelationshipEntity(endNodeType.getName()));
        }
        if (directedRelationship.direction().equals("OUTGOING")) {
            LOGGER.debug("context-del: ({})-[:{}]->()", (Object)identity, (Object)directedRelationship.type());
            return context.deregisterOutgoingRelationships(identity, directedRelationship.type(), endNodeType);
        }
        LOGGER.debug("context-del: ({})<-[:{}]-()", (Object)identity, (Object)directedRelationship.type());
        LOGGER.debug("context-del: ({})-[:{}]->()", (Object)identity, (Object)directedRelationship.type());
        boolean clearedIncoming = context.deregisterIncomingRelationships(identity, directedRelationship.type(), endNodeType, this.metaData.isRelationshipEntity(endNodeType.getName()));
        boolean clearedOutgoing = context.deregisterOutgoingRelationships(identity, directedRelationship.type(), endNodeType);
        return clearedIncoming || clearedOutgoing;
    }

    private void link(Compiler cypherCompiler, DirectedRelationship directedRelationship, NodeBuilder nodeBuilder, int horizon, boolean mapBothDirections, RelationshipNodes relNodes) {
        LOGGER.debug("linking to entity {} in {} direction", relNodes.target, (Object)(mapBothDirections ? "both" : "one"));
        if (relNodes.target != null) {
            CompileContext context = cypherCompiler.context();
            RelationshipBuilder relationshipBuilder = this.getRelationshipBuilder(cypherCompiler, relNodes.target, directedRelationship, mapBothDirections);
            if (this.isRelationshipEntity(relNodes.target)) {
                Long reIdentity = this.mappingContext.nativeId(relNodes.target);
                if (!context.visitedRelationshipEntity(reIdentity)) {
                    this.mapRelationshipEntity(relNodes.target, relNodes.source, relationshipBuilder, context, nodeBuilder, cypherCompiler, horizon, relNodes.sourceType, relNodes.targetType);
                } else {
                    LOGGER.debug("RE already visited {}: ", relNodes.target);
                }
            } else {
                this.mapRelatedEntity(cypherCompiler, nodeBuilder, relationshipBuilder, horizon, relNodes);
            }
        } else {
            LOGGER.debug("cannot create relationship: ({})-[:{}]->(null)", (Object)relNodes.sourceId, (Object)directedRelationship.type());
        }
    }

    private RelationshipBuilder getRelationshipBuilder(Compiler cypherBuilder, Object entity, DirectedRelationship directedRelationship, boolean mapBothDirections) {
        RelationshipBuilder relationshipBuilder;
        if (this.isRelationshipEntity(entity)) {
            Long relId = this.mappingContext.nativeId(entity);
            boolean relationshipIsNew = relId < 0L;
            boolean relationshipEndsChanged = this.haveRelationEndsChanged(entity, relId);
            if (relationshipIsNew || relationshipEndsChanged) {
                relationshipBuilder = cypherBuilder.newRelationship(directedRelationship.type());
                if (relationshipEndsChanged) {
                    EntityUtils.setIdentity(entity, null, this.metaData);
                }
            } else {
                relationshipBuilder = cypherBuilder.existingRelationship(relId, directedRelationship.type());
                this.mappingContext.getSnapshotOf(entity).ifPresent(snapshot -> {
                    RelationshipBuilder cfr_ignored_0 = (RelationshipBuilder)relationshipBuilder.setPreviousCompositeProperties(snapshot.getDynamicCompositeProperties());
                });
            }
        } else {
            relationshipBuilder = cypherBuilder.newRelationship(directedRelationship.type(), mapBothDirections);
        }
        relationshipBuilder.direction(directedRelationship.direction());
        if (this.isRelationshipEntity(entity)) {
            relationshipBuilder.setSingleton(false);
            relationshipBuilder.setReference(this.mappingContext.nativeId(entity));
            relationshipBuilder.setRelationshipEntity(true);
            ClassInfo classInfo = this.metaData.classInfo(entity);
            if (classInfo.primaryIndexField() != null) {
                relationshipBuilder.setPrimaryIdName(classInfo.primaryIndexField().propertyName());
            }
        }
        return relationshipBuilder;
    }

    private boolean haveRelationEndsChanged(Object entity, Long relId) {
        Object startEntity = this.getStartEntity(this.metaData.classInfo(entity), entity);
        Object targetEntity = this.getTargetEntity(this.metaData.classInfo(entity), entity);
        if (startEntity == null || targetEntity == null) {
            throw new MappingException("Relationship entity " + entity + " cannot have a missing start or end node");
        }
        Long tgtIdentity = this.mappingContext.nativeId(targetEntity);
        Long srcIdentity = this.mappingContext.nativeId(startEntity);
        boolean relationshipEndsChanged = false;
        for (MappedRelationship mappedRelationship : this.mappingContext.getRelationships()) {
            if (mappedRelationship.getRelationshipId() == null || relId == null || !mappedRelationship.getRelationshipId().equals(relId) || srcIdentity != null && tgtIdentity != null && mappedRelationship.getStartNodeId() == srcIdentity.longValue() && mappedRelationship.getEndNodeId() == tgtIdentity.longValue()) continue;
            relationshipEndsChanged = true;
            break;
        }
        return relationshipEndsChanged;
    }

    private void mapRelationshipEntity(Object relationshipEntity, Object parent, RelationshipBuilder relationshipBuilder, CompileContext context, NodeBuilder nodeBuilder, Compiler cypherCompiler, int horizon, Class startNodeType, Class endNodeType) {
        LOGGER.debug("mapping relationshipEntity {}", relationshipEntity);
        ClassInfo relEntityClassInfo = this.metaData.classInfo(relationshipEntity);
        this.updateRelationshipEntity(context, relationshipEntity, relationshipBuilder, relEntityClassInfo);
        Object startEntity = this.getStartEntity(relEntityClassInfo, relationshipEntity);
        Object targetEntity = this.getTargetEntity(relEntityClassInfo, relationshipEntity);
        Long tgtIdentity = this.mappingContext.nativeId(targetEntity);
        Long srcIdentity = this.mappingContext.nativeId(startEntity);
        RelationshipNodes relNodes = parent == targetEntity ? new RelationshipNodes(tgtIdentity, srcIdentity, startNodeType, endNodeType) : new RelationshipNodes(srcIdentity, tgtIdentity, startNodeType, endNodeType);
        if (this.mappingContext.isDirty(relationshipEntity)) {
            context.register(relationshipEntity);
            if (tgtIdentity >= 0L && srcIdentity >= 0L) {
                MappedRelationship mappedRelationship = this.createMappedRelationship(relationshipBuilder, relNodes);
                if (context.removeRegisteredRelationship(mappedRelationship)) {
                    LOGGER.debug("RE successfully marked for re-writing");
                } else {
                    LOGGER.debug("RE is new");
                }
            }
        } else {
            LOGGER.debug("RE is new or has not changed");
        }
        NodeBuilder srcNodeBuilder = context.visitedNode(startEntity);
        NodeBuilder tgtNodeBuilder = context.visitedNode(targetEntity);
        if (parent == targetEntity) {
            if (!context.visited(startEntity, horizon)) {
                relNodes.source = targetEntity;
                relNodes.target = startEntity;
                this.mapRelatedEntity(cypherCompiler, nodeBuilder, relationshipBuilder, horizon, relNodes);
            } else {
                this.updateRelationship(context, tgtNodeBuilder, srcNodeBuilder, relationshipBuilder, relNodes);
            }
        } else if (!context.visited(targetEntity, horizon)) {
            relNodes.source = startEntity;
            relNodes.target = targetEntity;
            this.mapRelatedEntity(cypherCompiler, nodeBuilder, relationshipBuilder, horizon, relNodes);
        } else {
            this.updateRelationship(context, srcNodeBuilder, tgtNodeBuilder, relationshipBuilder, relNodes);
        }
    }

    private void updateRelationshipEntity(CompileContext context, Object relationshipEntity, RelationshipBuilder relationshipBuilder, ClassInfo relEntityClassInfo) {
        Long reIdentity = this.mappingContext.nativeId(relationshipEntity);
        context.visitRelationshipEntity(reIdentity);
        AnnotationInfo annotation = relEntityClassInfo.annotationsInfo().get(RelationshipEntity.class);
        if (relationshipBuilder.type() == null) {
            relationshipBuilder.setType(annotation.get("type", relEntityClassInfo.name()));
        }
        if (reIdentity < 0L) {
            context.registerNewObject(reIdentity, relationshipEntity);
        }
        this.updateFieldsOnBuilder(relationshipEntity, relationshipBuilder, relEntityClassInfo);
    }

    private <T> void updateFieldsOnBuilder(Object entity, PropertyContainerBuilder<T> builder, ClassInfo classInfo) {
        for (FieldInfo fieldInfo : classInfo.propertyFields()) {
            if (fieldInfo.isComposite()) {
                Map<String, ?> properties = fieldInfo.readComposite(entity);
                builder.addCompositeProperties(properties);
                continue;
            }
            if (fieldInfo.isVersionField()) {
                this.updateVersionField(entity, builder, fieldInfo);
                continue;
            }
            builder.addProperty(fieldInfo.propertyName(), fieldInfo.readProperty(entity));
        }
    }

    private <T> void updateVersionField(Object entity, PropertyContainerBuilder<T> builder, FieldInfo fieldInfo) {
        Long version = (Long)fieldInfo.readProperty(entity);
        builder.setVersionProperty(fieldInfo.propertyName(), version);
        version = version == null ? Long.valueOf(0L) : Long.valueOf(version + 1L);
        fieldInfo.writeDirect(entity, version);
        builder.addProperty(fieldInfo.propertyName(), version);
    }

    private Object getStartEntity(ClassInfo relEntityClassInfo, Object relationshipEntity) {
        FieldInfo actualStartNodeReader = relEntityClassInfo.getStartNodeReader();
        if (actualStartNodeReader != null) {
            return actualStartNodeReader.read(relationshipEntity);
        }
        throw new RuntimeException("@StartNode of a relationship entity may not be null");
    }

    private Object getTargetEntity(ClassInfo relEntityClassInfo, Object relationshipEntity) {
        FieldInfo actualEndNodeReader = relEntityClassInfo.getEndNodeReader();
        if (actualEndNodeReader != null) {
            return actualEndNodeReader.read(relationshipEntity);
        }
        throw new RuntimeException("@EndNode of a relationship entity may not be null");
    }

    private MappedRelationship createMappedRelationship(RelationshipBuilder relationshipBuilder, RelationshipNodes relNodes) {
        MappedRelationship mappedRelationshipOutgoing = new MappedRelationship(relNodes.sourceId, relationshipBuilder.type(), relNodes.targetId, relationshipBuilder.reference(), relNodes.sourceType, relNodes.targetType);
        MappedRelationship mappedRelationshipIncoming = new MappedRelationship(relNodes.targetId, relationshipBuilder.type(), relNodes.sourceId, relationshipBuilder.reference(), relNodes.sourceType, relNodes.targetType);
        if (!relationshipBuilder.isRelationshipEntity()) {
            mappedRelationshipIncoming.setRelationshipId(null);
            mappedRelationshipOutgoing.setRelationshipId(null);
        }
        if (relationshipBuilder.hasDirection("UNDIRECTED")) {
            if (this.mappingContext.containsRelationship(mappedRelationshipIncoming)) {
                return mappedRelationshipIncoming;
            }
            return mappedRelationshipOutgoing;
        }
        if (relationshipBuilder.hasDirection("INCOMING")) {
            return mappedRelationshipIncoming;
        }
        return mappedRelationshipOutgoing;
    }

    private void mapRelatedEntity(Compiler compiler, NodeBuilder srcNodeBuilder, RelationshipBuilder relationshipBuilder, int horizon, RelationshipNodes relNodes) {
        NodeBuilder tgtNodeBuilder = this.mapEntity(relNodes.target, horizon, compiler);
        if (tgtNodeBuilder != null) {
            LOGGER.debug("trying to map relationship between {} and {}", relNodes.source, relNodes.target);
            CompileContext context = compiler.context();
            relNodes.targetId = this.mappingContext.nativeId(relNodes.target);
            this.updateRelationship(context, srcNodeBuilder, tgtNodeBuilder, relationshipBuilder, relNodes);
        }
    }

    private void updateRelationship(CompileContext context, NodeBuilder srcNodeBuilder, NodeBuilder tgtNodeBuilder, RelationshipBuilder relationshipBuilder, RelationshipNodes relNodes) {
        if (relNodes.targetId == null || relNodes.sourceId == null) {
            this.maybeCreateRelationship(context, srcNodeBuilder.reference(), relationshipBuilder, tgtNodeBuilder.reference(), relNodes.sourceType, relNodes.targetType);
        } else {
            MappedRelationship mappedRelationship = this.createMappedRelationship(relationshipBuilder, relNodes);
            if (!this.mappingContext.containsRelationship(mappedRelationship)) {
                this.maybeCreateRelationship(context, srcNodeBuilder.reference(), relationshipBuilder, tgtNodeBuilder.reference(), relNodes.sourceType, relNodes.targetType);
            } else {
                LOGGER.debug("context-add: ({})-[{}:{}]->({})", new Object[]{mappedRelationship.getStartNodeId(), relationshipBuilder.reference(), mappedRelationship.getRelationshipType(), mappedRelationship.getEndNodeId()});
                mappedRelationship.activate();
                context.registerRelationship(mappedRelationship);
            }
        }
    }

    private void maybeCreateRelationship(CompileContext context, Long src, RelationshipBuilder relationshipBuilder, Long tgt, Class srcClass, Class tgtClass) {
        if (this.hasTransientRelationship(context, src, relationshipBuilder, tgt)) {
            LOGGER.debug("new relationship is already registered");
            if (relationshipBuilder.isBidirectional()) {
                relationshipBuilder.relate(src, tgt);
                context.registerTransientRelationship(new SrcTargetKey(src.longValue(), tgt.longValue()), new TransientRelationship(src, relationshipBuilder.reference(), relationshipBuilder.type(), tgt, tgtClass, srcClass));
            }
            return;
        }
        if (relationshipBuilder.hasDirection("INCOMING")) {
            if (this.metaData.isRelationshipEntity(tgtClass.getName())) {
                srcClass = tgtClass;
                String start = this.metaData.classInfo(tgtClass.getName()).getStartNodeReader().typeDescriptor();
                tgtClass = ClassUtils.getType(start);
            }
            this.reallyCreateRelationship(context, tgt, relationshipBuilder, src, tgtClass, srcClass);
        } else {
            this.reallyCreateRelationship(context, src, relationshipBuilder, tgt, srcClass, tgtClass);
        }
    }

    private boolean hasTransientRelationship(CompileContext ctx, Long src, RelationshipBuilder relationshipBuilder, Long tgt) {
        for (Object object : ctx.getTransientRelationships(new SrcTargetKey(src.longValue(), tgt.longValue()))) {
            if (!(object instanceof TransientRelationship) || !((TransientRelationship)object).equals(src, relationshipBuilder, tgt)) continue;
            return true;
        }
        return false;
    }

    private void reallyCreateRelationship(CompileContext ctx, Long src, RelationshipBuilder relBuilder, Long tgt, Class srcClass, Class tgtClass) {
        relBuilder.relate(src, tgt);
        LOGGER.debug("context-new: ({})-[{}:{}]->({})", new Object[]{src, relBuilder.reference(), relBuilder.type(), tgt});
        if (relBuilder.isNew()) {
            ctx.registerTransientRelationship(new SrcTargetKey(src.longValue(), tgt.longValue()), new TransientRelationship(src, relBuilder.reference(), relBuilder.type(), tgt, srcClass, tgtClass));
        }
    }

    private boolean isRelationshipEntity(Object potentialRelationshipEntity) {
        ClassInfo classInfo = this.metaData.classInfo(potentialRelationshipEntity);
        return classInfo != null && null != classInfo.annotationsInfo().get(RelationshipEntity.class);
    }

    private boolean bothWayMappingRequired(Object srcObject, String relationshipType, Object tgtObject, String relationshipDirection) {
        boolean mapBothWays = false;
        ClassInfo tgtInfo = this.metaData.classInfo(tgtObject);
        if (tgtInfo == null) {
            LOGGER.warn("Unable to process {} on {}. Check the mapping.", (Object)relationshipType, srcObject.getClass());
            return false;
        }
        for (FieldInfo tgtRelReader : tgtInfo.relationshipFields()) {
            Object target;
            String tgtRelationshipDirection = tgtRelReader.relationshipDirection();
            if (!tgtRelationshipDirection.equals("OUTGOING") && !tgtRelationshipDirection.equals("INCOMING") || !tgtRelReader.relationshipType().equals(relationshipType) || !relationshipDirection.equals(tgtRelationshipDirection) || (target = tgtRelReader.read(tgtObject)) == null) continue;
            if (target instanceof Iterable) {
                for (Object relatedObject : (Iterable)target) {
                    if (!relatedObject.equals(srcObject)) continue;
                    mapBothWays = true;
                }
                continue;
            }
            if (target.getClass().isArray()) {
                for (Object relatedObject : (Object[])target) {
                    if (!relatedObject.equals(srcObject)) continue;
                    mapBothWays = true;
                }
                continue;
            }
            if (!target.equals(srcObject)) continue;
            mapBothWays = true;
        }
        return mapBothWays;
    }

    static class RelationshipNodes {
        Long sourceId;
        Long targetId;
        Class sourceType;
        Class targetType;
        Object source;
        Object target;

        RelationshipNodes(Long sourceId, Long targetId, Class sourceType, Class targetType) {
            this.sourceId = sourceId;
            this.targetId = targetId;
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        RelationshipNodes(Object source, Object target, Class sourceType, Class targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.source = source;
            this.target = target;
        }

        public String toString() {
            return "RelationshipNodes{sourceId=" + this.sourceId + ", targetId=" + this.targetId + ", sourceType=" + this.sourceType + ", targetType=" + this.targetType + ", source=" + this.source + ", target=" + this.target + '}';
        }
    }
}

