/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;
import org.neo4j.ogm.metadata.reflect.EntityFactory;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.session.EntityInstantiator;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUseEntityMapper {
    private static final Logger logger = LoggerFactory.getLogger(SingleUseEntityMapper.class);
    private final EntityFactory entityFactory;
    private final MetaData metadata;

    public SingleUseEntityMapper(MetaData mappingMetaData, EntityFactory entityFactory) {
        this.metadata = mappingMetaData;
        this.entityFactory = new EntityFactory(mappingMetaData);
    }

    public SingleUseEntityMapper(MetaData mappingMetaData, EntityInstantiator entityInstantiator) {
        this.metadata = mappingMetaData;
        this.entityFactory = new EntityFactory(mappingMetaData, entityInstantiator);
    }

    public <T> T map(Class<T> type, String[] columnNames, RowModel rowModel) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < rowModel.getValues().length; ++i) {
            properties.put(columnNames[i], rowModel.getValues()[i]);
        }
        T entity = this.entityFactory.newObject(type, properties);
        this.setPropertiesOnEntity(entity, properties);
        return entity;
    }

    public <T> T map(Class<T> type, Map<String, Object> row) {
        T entity = this.entityFactory.newObject(type, row);
        this.setPropertiesOnEntity(entity, row);
        return entity;
    }

    private void setPropertiesOnEntity(Object entity, Map<String, Object> propertyMap) {
        ClassInfo classInfo = this.resolveClassInfoFor(entity.getClass());
        for (Map.Entry<String, Object> propertyMapEntry : propertyMap.entrySet()) {
            this.writeProperty(classInfo, entity, propertyMapEntry);
        }
    }

    private ClassInfo resolveClassInfoFor(Class<?> type) {
        ClassInfo classInfo = this.metadata.classInfo(type.getSimpleName());
        if (classInfo != null) {
            return classInfo;
        }
        throw new MappingException("Error mapping to ad-hoc " + type + ".  At present, only @Result types that are discovered by the domain entity package scanning can be mapped.");
    }

    private void writeProperty(ClassInfo classInfo, Object instance, Map.Entry<String, Object> property) {
        FieldInfo idField;
        FieldInfo fieldInfo;
        FieldInfo writer = classInfo.getFieldInfo(property.getKey());
        if (writer == null && (fieldInfo = classInfo.relationshipFieldByName(property.getKey())) != null) {
            writer = fieldInfo;
        }
        if (writer == null && property.getKey().equals("id") && (idField = classInfo.identityField()) != null) {
            writer = idField;
        }
        if (writer != null) {
            List<Object> value = property.getValue();
            if (value != null && value.getClass().isArray()) {
                value = Arrays.asList((Object[])value);
            }
            if (writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) {
                Class elementType = this.underlyingElementType(classInfo, property.getKey());
                value = writer.type().isArray() ? EntityAccessManager.merge(writer.type(), value, new Object[0], elementType) : EntityAccessManager.merge(writer.type(), value, Collections.EMPTY_LIST, elementType);
            }
            writer.write(instance, value);
        } else {
            logger.warn("Unable to find property: {} on class: {} for writing", (Object)property.getKey(), (Object)classInfo.name());
        }
    }

    private Class underlyingElementType(ClassInfo classInfo, String propertyName) {
        FieldInfo fieldInfo = classInfo.propertyField(propertyName);
        if (fieldInfo != null) {
            return ClassUtils.getType(fieldInfo.getTypeDescriptor());
        }
        return classInfo.getUnderlyingClass();
    }
}

