/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.context.WriteProtectionTarget;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.WriteProtectionStrategy;
import org.neo4j.ogm.session.delegates.DefaultWriteProtectionStrategyImpl;
import org.neo4j.ogm.session.delegates.SaveEventDelegate;
import org.neo4j.ogm.session.delegates.SessionDelegate;
import org.neo4j.ogm.session.request.RequestExecutor;

public class SaveDelegate
extends SessionDelegate {
    private final RequestExecutor requestExecutor;
    private WriteProtectionStrategy writeProtectionStrategy;

    public SaveDelegate(Neo4jSession session) {
        super(session);
        this.requestExecutor = new RequestExecutor(session);
    }

    public <T> void save(T object) {
        this.save(object, -1);
    }

    public <T> void save(T object, int depth) {
        List<Object> objects;
        SaveEventDelegate eventsDelegate = new SaveEventDelegate(this.session);
        EntityGraphMapper entityGraphMapper = new EntityGraphMapper(this.session.metaData(), this.session.context());
        if (this.writeProtectionStrategy != null) {
            entityGraphMapper.addWriteProtection((BiFunction)this.writeProtectionStrategy.get());
        }
        if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            ArrayList<T> copy = new ArrayList<T>(length);
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(object, i);
                copy.add(arrayElement);
            }
            objects = copy;
        } else if (Iterable.class.isAssignableFrom(object.getClass())) {
            objects = (List<Object>)object;
        } else if (this.session.metaData().classInfo(object) != null) {
            objects = Collections.singletonList(object);
        } else {
            throw new IllegalArgumentException("Class " + object.getClass() + " is not a valid entity class. Please check the entity mapping.");
        }
        if (this.session.eventsEnabled()) {
            objects.forEach(item -> {
                eventsDelegate.preSave(item);
                entityGraphMapper.map(item, depth);
            });
            this.requestExecutor.executeSave(entityGraphMapper.compileContext());
            eventsDelegate.postSave();
        } else {
            objects.forEach(item -> entityGraphMapper.map(item, depth));
            this.requestExecutor.executeSave(entityGraphMapper.compileContext());
        }
    }

    public void addWriteProtection(WriteProtectionTarget target, Predicate<Object> protection) {
        if (this.writeProtectionStrategy == null) {
            this.writeProtectionStrategy = new DefaultWriteProtectionStrategyImpl();
        } else if (!(this.writeProtectionStrategy instanceof DefaultWriteProtectionStrategyImpl)) {
            throw new IllegalStateException("Cannot register simple write protection for a mode on a custom strategy. Use #setWriteProtectionStrategy(null) to remove any custom strategy.");
        }
        ((DefaultWriteProtectionStrategyImpl)this.writeProtectionStrategy).addProtection(target, protection);
    }

    public void removeWriteProtection(WriteProtectionTarget target) {
        if (this.writeProtectionStrategy == null || !(this.writeProtectionStrategy instanceof DefaultWriteProtectionStrategyImpl)) {
            return;
        }
        DefaultWriteProtectionStrategyImpl writeProtectionStrategy = (DefaultWriteProtectionStrategyImpl)this.writeProtectionStrategy;
        writeProtectionStrategy.removeProtection(target);
        if (writeProtectionStrategy.isEmpty()) {
            this.writeProtectionStrategy = null;
        }
    }

    public void setWriteProtectionStrategy(WriteProtectionStrategy writeProtectionStrategy) {
        this.writeProtectionStrategy = writeProtectionStrategy;
    }
}

