/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Map;
import org.neo4j.ogm.metadata.schema.Node;
import org.neo4j.ogm.metadata.schema.Relationship;
import org.neo4j.ogm.metadata.schema.Schema;

public abstract class AbstractSchemaLoadClauseBuilder {
    protected final Schema schema;
    protected final boolean pretty;

    public AbstractSchemaLoadClauseBuilder(Schema schema) {
        this.pretty = false;
        this.schema = schema;
    }

    protected void expand(StringBuilder sb, String variable, Node node, int depth) {
        if (depth > 0) {
            if (node.relationships().size() > 0) {
                sb.append(",[ ");
            }
            this.expand(sb, variable, node, 1, depth - 1);
            if (node.relationships().size() > 0) {
                sb.append(" ]");
            }
        }
    }

    protected void expand(StringBuilder sb, String variable, Node node, int level, int depth) {
        for (Map.Entry<String, Relationship> entry : node.relationships().entrySet()) {
            if (this.needsSeparator(sb)) {
                sb.append(", ");
            }
            this.listComprehension(sb, variable, entry.getValue(), node, level, depth);
        }
    }

    private boolean needsSeparator(StringBuilder sb) {
        for (int i = sb.length() - 1; i >= 0; --i) {
            char ch = sb.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return ch != '[' && ch != ',';
        }
        return false;
    }

    private void listComprehension(StringBuilder sb, String fromNodeVar, Relationship relationship, Node node, int level, int depth) {
        String direction = relationship.direction(node);
        Node toNode = relationship.other(node);
        String relVar = this.relVariableName(relationship, level);
        String toNodeVar = this.variableName(toNode, level);
        sb.append("[ (");
        sb.append(fromNodeVar);
        sb.append(")");
        switch (direction) {
            case "INCOMING": {
                this.appendRel(sb, relVar, relationship.type(), "<-[", "]-");
                break;
            }
            case "OUTGOING": {
                this.appendRel(sb, relVar, relationship.type(), "-[", "]->");
                break;
            }
            default: {
                this.appendRel(sb, relVar, relationship.type(), "-[", "]-");
            }
        }
        sb.append("(");
        sb.append(toNodeVar);
        if (toNode.label().isPresent()) {
            sb.append(":`");
            sb.append(toNode.label().get());
            sb.append("`");
        }
        sb.append(") | [ ");
        sb.append(relVar);
        sb.append(", ");
        sb.append(toNodeVar);
        if (depth > 0 && !toNode.relationships().isEmpty()) {
            sb.append(", [ ");
            this.expand(sb, toNodeVar, toNode, level + 1, depth - 1);
            sb.append(" ]");
        }
        sb.append(" ] ]");
    }

    private String relVariableName(Relationship relationship, int level) {
        return "r_" + Character.toLowerCase(relationship.type().charAt(0)) + level;
    }

    private String variableName(Node node, int level) {
        String label = node.label().orElse("x");
        char name = label.charAt(0);
        return "" + Character.toLowerCase(name) + level;
    }

    private void appendRel(StringBuilder sb, String variable, String type, String start, String end) {
        sb.append(start).append(variable).append(":`").append(type).append("`").append(end);
    }

    protected void newLine(StringBuilder sb) {
        if (this.pretty) {
            sb.append("\n");
        }
    }
}

