/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import org.pcap4j.core.NativeMappings;
import org.pcap4j.packet.Packet;

public final class BpfProgram {
    private final NativeMappings.bpf_program program;
    private final String expression;
    private volatile boolean freed = false;
    private final Object lock = new Object();

    BpfProgram(NativeMappings.bpf_program program, String expression) {
        this.program = program;
        this.expression = expression;
    }

    NativeMappings.bpf_program getProgram() {
        return this.program;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean applyFilter(Packet packet) {
        return this.applyFilter(packet.getRawData());
    }

    public boolean applyFilter(byte[] packet) {
        return this.applyFilter(packet, packet.length, packet.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyFilter(byte[] packet, int orgPacketLen, int packetLen) {
        Object object = this.lock;
        synchronized (object) {
            if (this.freed) {
                return false;
            }
            if (this.program.bf_insns == null) {
                this.program.read();
            }
            return NativeMappings.bpf_filter(this.program.bf_insns, packet, orgPacketLen, packetLen) != 0;
        }
    }

    public boolean isFreed() {
        return this.freed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() {
        if (this.freed) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.freed) {
                return;
            }
            NativeMappings.pcap_freecode(this.program);
            this.freed = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.free();
    }

    public static enum BpfCompileMode {
        OPTIMIZE(1),
        NONOPTIMIZE(0);

        private final int value;

        private BpfCompileMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

