/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.datetime;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.pojava.datetime.DateTimeConfigBuilder;
import org.pojava.datetime.IDateTimeConfig;
import org.pojava.datetime.MonthMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeConfig
implements IDateTimeConfig,
Serializable {
    private static final long serialVersionUID = 3L;
    private static IDateTimeConfig globalDefault = null;
    private boolean isDmyOrder = false;
    private boolean isUnspecifiedCenturyAlwaysInPast = false;
    private int epochDOW = 4;
    private String format = "yyyy-MM-dd HH:mm:ss";
    private String defaultJdbcFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private TimeZone inputTimeZone = TimeZone.getDefault();
    private TimeZone outputTimeZone = TimeZone.getDefault();
    private Locale locale = Locale.getDefault();
    private String bcPrefix = "-";
    private MonthMap monthMap;
    private final Map<String, String> tzMap = new HashMap<String, String>();
    private final Map<String, TimeZone> tzCache = new HashMap<String, TimeZone>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalDefault(IDateTimeConfig globalDefault) {
        if (globalDefault != null) {
            globalDefault.validate();
        }
        Class<DateTimeConfig> clazz = DateTimeConfig.class;
        synchronized (DateTimeConfig.class) {
            DateTimeConfig.globalDefault = globalDefault;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDateTimeConfig getGlobalDefault() {
        if (globalDefault != null) return globalDefault;
        Class<DateTimeConfig> clazz = DateTimeConfig.class;
        synchronized (DateTimeConfig.class) {
            if (globalDefault != null) return globalDefault;
            globalDefault = DateTimeConfig.defaultDateTimeConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return globalDefault;
        }
    }

    private static DateTimeConfig defaultDateTimeConfig() {
        TimeZone tz = TimeZone.getDefault();
        DateTimeConfig dtc = new DateTimeConfig();
        dtc.monthMap = MonthMap.fromAllLocales();
        dtc.tzMap.put("Z", "UTC");
        dtc.tzCache.put(tz.getID(), tz);
        dtc.validate();
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        if (df instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)df).toPattern();
            dtc.isDmyOrder = !pattern.startsWith("M");
        }
        return dtc;
    }

    @Override
    public boolean isDmyOrder() {
        return this.isDmyOrder;
    }

    @Override
    public Map<String, String> getTzMap() {
        return this.tzMap;
    }

    public void addTzMap(Map<String, String> tzMap) {
        this.tzMap.putAll(tzMap);
    }

    @Override
    public void validate() {
        if (this.monthMap == null || this.monthMap.isEmpty()) {
            throw new IllegalStateException("Month Map is required.");
        }
        if (this.inputTimeZone == null) {
            throw new IllegalStateException("Input TimeZone must be non-null.");
        }
        if (this.outputTimeZone == null) {
            throw new IllegalStateException("Output TimeZone must be non-null.");
        }
    }

    @Override
    public int getEpochDOW() {
        return this.epochDOW;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public String getDefaultJdbcFormat() {
        return this.defaultJdbcFormat;
    }

    @Override
    public TimeZone lookupTimeZone(String id) {
        return this.lookupTimeZone(id, this.inputTimeZone);
    }

    @Override
    public TimeZone lookupTimeZone(String id, TimeZone defaultTimeZone) {
        TimeZone tz;
        if (id == null) {
            tz = defaultTimeZone;
        } else if (!this.tzCache.containsKey(id)) {
            tz = TimeZone.getTimeZone(id);
            if (!(!"GMT".equals(tz.getID()) || "GMT".equals(id) || "UTC".equals(id) || "CUT".equals(id) || "Z".equals(id) || "WET".equals(id))) {
                return defaultTimeZone;
            }
            this.tzCache.put(id, tz);
        } else {
            tz = this.tzCache.get(id);
        }
        return tz;
    }

    @Override
    public Integer lookupMonthIndex(String monthNameOrAbbreviation) {
        return this.monthMap.monthIndex(monthNameOrAbbreviation);
    }

    @Override
    public TimeZone getInputTimeZone() {
        return this.inputTimeZone;
    }

    @Override
    public TimeZone getOutputTimeZone() {
        return this.outputTimeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isUnspecifiedCenturyAlwaysInPast() {
        return this.isUnspecifiedCenturyAlwaysInPast;
    }

    @Override
    public String getBcPrefix() {
        return this.bcPrefix;
    }

    @Override
    public long systemTime() {
        return System.currentTimeMillis();
    }

    public static void setGlobalDefaultFromBuilder(DateTimeConfigBuilder builder) {
        globalDefault = DateTimeConfig.fromBuilder(builder);
    }

    public static DateTimeConfig fromBuilder(DateTimeConfigBuilder builder) {
        DateTimeConfig dtc = new DateTimeConfig();
        dtc.monthMap = builder.getMonthMap();
        dtc.bcPrefix = builder.getBcPrefix();
        dtc.defaultJdbcFormat = builder.getDefaultJdbcFormat();
        dtc.epochDOW = builder.getEpochDOW();
        dtc.format = builder.getFormat();
        dtc.inputTimeZone = builder.getInputTimeZone();
        dtc.isDmyOrder = builder.isDmyOrder();
        dtc.isUnspecifiedCenturyAlwaysInPast = builder.isUnspecifiedCenturyAlwaysInPast();
        dtc.locale = builder.getLocale();
        dtc.outputTimeZone = builder.getOutputTimeZone();
        dtc.tzMap.putAll(builder.getTzMap());
        dtc.tzCache.putAll(builder.getTzCache());
        dtc.validate();
        return dtc;
    }
}

