/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.datetime;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.pojava.datetime.MonthMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeConfigBuilder {
    private boolean isDmyOrder = false;
    private boolean isUnspecifiedCenturyAlwaysInPast = false;
    private int epochDOW = 4;
    private String format = "yyyy-MM-dd HH:mm:ss";
    private String defaultJdbcFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private TimeZone inputTimeZone = TimeZone.getDefault();
    private TimeZone outputTimeZone = TimeZone.getDefault();
    private Locale locale = Locale.getDefault();
    private String bcPrefix = "-";
    private MonthMap monthMap;
    private final Map<String, String> tzMap = new HashMap<String, String>();
    private final Map<String, TimeZone> tzCache = new HashMap<String, TimeZone>();

    public static DateTimeConfigBuilder newInstance() {
        DateTimeConfigBuilder builder = new DateTimeConfigBuilder();
        builder.monthMap = MonthMap.fromAllLocales();
        return builder;
    }

    public boolean isDmyOrder() {
        return this.isDmyOrder;
    }

    public void setDmyOrder(boolean isDmyOrder) {
        this.isDmyOrder = isDmyOrder;
    }

    public DateTimeConfigBuilder dmyOrder(boolean isDmyOrder) {
        this.isDmyOrder = isDmyOrder;
        return this;
    }

    public boolean isUnspecifiedCenturyAlwaysInPast() {
        return this.isUnspecifiedCenturyAlwaysInPast;
    }

    public void setUnspecifiedCenturyAlwaysInPast(boolean isUnspecifiedCenturyAlwaysInPast) {
        this.isUnspecifiedCenturyAlwaysInPast = isUnspecifiedCenturyAlwaysInPast;
    }

    public DateTimeConfigBuilder unspecifiedCenturyAlwaysInPast(boolean isUnspecifiedCenturyAlwaysInPast) {
        this.isUnspecifiedCenturyAlwaysInPast = isUnspecifiedCenturyAlwaysInPast;
        return this;
    }

    public int getEpochDOW() {
        return this.epochDOW;
    }

    public void setEpochDOW(int epochDOW) {
        this.epochDOW = epochDOW;
    }

    public DateTimeConfigBuilder epochDOW(int epochDOW) {
        this.epochDOW = epochDOW;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public DateTimeConfigBuilder format(String format) {
        this.format = format;
        return this;
    }

    public String getDefaultJdbcFormat() {
        return this.defaultJdbcFormat;
    }

    public DateTimeConfigBuilder defaultJdbcFormat(String defaultJdbcFormat) {
        this.defaultJdbcFormat = defaultJdbcFormat;
        return this;
    }

    public void setDefaultJdbcFormat(String defaultJdbcFormat) {
        this.defaultJdbcFormat = defaultJdbcFormat;
    }

    public TimeZone getInputTimeZone() {
        return this.inputTimeZone;
    }

    public DateTimeConfigBuilder inputTimeZone(TimeZone inputTimeZone) {
        this.inputTimeZone = inputTimeZone;
        return this;
    }

    public void setInputTimeZone(TimeZone inputTimeZone) {
        this.inputTimeZone = inputTimeZone;
    }

    public TimeZone getOutputTimeZone() {
        return this.outputTimeZone;
    }

    public DateTimeConfigBuilder outputTimeZone(TimeZone outputTimeZone) {
        this.outputTimeZone = outputTimeZone;
        return this;
    }

    public void setOutputTimeZone(TimeZone outputTimeZone) {
        this.outputTimeZone = outputTimeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public DateTimeConfigBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public String getBcPrefix() {
        return this.bcPrefix;
    }

    public void setBcPrefix(String bcPrefix) {
        this.bcPrefix = bcPrefix;
    }

    public DateTimeConfigBuilder bcPrefix(String bcPrefix) {
        this.bcPrefix = bcPrefix;
        return this;
    }

    public MonthMap getMonthMap() {
        return this.monthMap;
    }

    public void setMonthMap(MonthMap monthMap) {
        this.monthMap = monthMap;
    }

    public DateTimeConfigBuilder monthMap(MonthMap monthMap) {
        this.monthMap = monthMap;
        return this;
    }

    public void addTimeZone(String id, TimeZone tz) {
        this.tzCache.put(id, tz);
    }

    public Map<String, TimeZone> getTzCache() {
        return this.tzCache;
    }

    public void addTzMap(String id1, String id2) {
        this.tzMap.put(id1, id2);
    }

    public Map<String, String> getTzMap() {
        return this.tzMap;
    }
}

