/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.datetime;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Duration
implements Comparable<Duration>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final long MILLISECOND = 1L;
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    private static final int NANOS_PER_MILLI = 1000000;
    protected long millis = 0L;
    protected int nanos = 0;

    public Duration() {
    }

    public Duration(String duration) {
        char[] chars = duration.toCharArray();
        double accum = 0.0;
        double tot = 0.0;
        double dec = 1.0;
        int sign = 1;
        for (char c : chars) {
            if (c == '.') {
                dec /= 10.0;
                continue;
            }
            if (c == '-') {
                sign = -1;
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (Math.abs(dec) > 0.5) {
                    accum = accum * 10.0 + (double)sign * dec * (double)(c - 48);
                    continue;
                }
                accum += (double)sign * dec * (double)(c - 48);
                dec /= 10.0;
                continue;
            }
            if (c == 'w' || c == 'W') {
                if (accum == 0.0) continue;
                tot += 6.048E8 * accum;
                accum = 0.0;
                dec = 1.0;
                continue;
            }
            if (c == 'd' || c == 'D') {
                if (accum == 0.0) continue;
                tot += 8.64E7 * accum;
                accum = 0.0;
                dec = 1.0;
                continue;
            }
            if (c == 'h' || c == 'H') {
                if (accum == 0.0) continue;
                tot += 3600000.0 * accum;
                accum = 0.0;
                dec = 1.0;
                continue;
            }
            if (c == 'm' || c == 'M' || c == '\'') {
                if (accum == 0.0) continue;
                tot += 60000.0 * accum;
                accum = 0.0;
                dec = 1.0;
                continue;
            }
            if (c == 's' || c == 'S' || c == '\"') {
                if (accum == 0.0) continue;
                tot += 1000.0 * accum;
                accum = 0.0;
                dec = 1.0;
                continue;
            }
            if (c != 'n' && c != 'N' || accum == 0.0) continue;
            tot += accum / 1000000.0;
            accum = 0.0;
            dec = 1.0;
        }
        tot = tot > 0.0 ? (tot += 1.0E-7) : (tot -= 1.0E-7);
        this.millis = (long)tot;
        tot /= 1000.0;
        tot -= (double)((long)tot);
        this.nanos = (int)((tot *= 1000.0) * 1000000.0);
    }

    public Duration(long millis) {
        this.millis = millis;
        int calcNanos = (int)(millis % 1000L) * 1000000;
        this.nanos = calcNanos < 0 ? 1000000000 + calcNanos : calcNanos;
    }

    public Duration(long seconds, int nanos) {
        while (nanos > 999999999) {
            ++seconds;
            nanos -= 1000000000;
        }
        while (nanos < 0) {
            --seconds;
            nanos += 1000000000;
        }
        this.millis = seconds * 1000L + (long)(nanos / 1000000);
        this.nanos = nanos;
        if (this.millis < 0L && this.nanos > 0) {
            this.millis -= 1000L;
        }
    }

    public Duration add(Duration dur) {
        return new Duration(this.getSeconds() + dur.getSeconds(), this.nanos + dur.nanos);
    }

    public Duration add(long milliseconds) {
        Duration d = new Duration(this.toMillis() + milliseconds);
        d.nanos += this.nanos % 1000000;
        return d;
    }

    public Duration add(long seconds, int nanos) {
        if (nanos > 999999999) {
            ++seconds;
            nanos -= 1000000000;
        }
        return new Duration(this.getSeconds() + seconds, this.nanos + nanos);
    }

    @Override
    public int compareTo(Duration other) {
        if (other == null) {
            throw new NullPointerException("Cannot compare Duration to null.");
        }
        if (this.millis == other.millis) {
            return this.nanos < other.nanos ? -1 : (this.nanos == other.nanos ? 0 : 1);
        }
        return this.millis < other.millis ? -1 : 1;
    }

    public boolean equals(Object other) {
        return other instanceof Duration && this.compareTo((Duration)other) == 0;
    }

    public int hashCode() {
        return (int)(this.millis & 0xFFFFL ^ (long)this.nanos);
    }

    public int getNanos() {
        return this.nanos;
    }

    public long toMillis() {
        return this.millis;
    }

    public long getSeconds() {
        return this.millis / 1000L - (long)(this.nanos < 0 ? 1 : 0);
    }

    public static Duration parse(String str) {
        return new Duration(str);
    }

    private long extract(long ms, long interval, String label, StringBuilder sb) {
        long unit = 0L;
        unit = ms / interval;
        sb.append(unit);
        sb.append(label);
        return ms -= unit * interval;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        long ms = this.millis;
        int ns = this.nanos;
        if (ms < 0L || ms == 0L && ns < 0) {
            sb.append("-");
            ms *= -1L;
            ns *= -1;
        }
        if (ms > 86400000L) {
            ms = this.extract(ms, 86400000L, "d", sb);
        }
        if (ms > 3600000L) {
            ms = this.extract(ms, 3600000L, "h", sb);
        }
        if (ms > 60000L) {
            ms = this.extract(ms, 60000L, "m", sb);
        }
        if (ms > 1000L) {
            this.extract(ms, 1000L, "s", sb);
        }
        if (ns > 0) {
            sb.append(ns);
            sb.append("n");
        }
        return sb.toString();
    }
}

