/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.datetime;

import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.pojava.datetime.IDateTimeConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConfig
implements IDateTimeConfig {
    private TimeZone inputTimeZone;
    private TimeZone outputTimeZone;
    private IDateTimeConfig config;

    public static LocalConfig instanceOverridingOutputTimeZone(IDateTimeConfig baseConfig, TimeZone outputTimeZone) {
        return new LocalConfig(baseConfig, baseConfig.getInputTimeZone(), outputTimeZone);
    }

    public static LocalConfig instanceOverridingTimeZones(IDateTimeConfig baseConfig, TimeZone inputTimeZone, TimeZone outputTimeZone) {
        return new LocalConfig(baseConfig, inputTimeZone, outputTimeZone);
    }

    protected LocalConfig(IDateTimeConfig config, TimeZone inputTimeZone, TimeZone outputTimeZone) {
        this.config = config;
        this.inputTimeZone = inputTimeZone;
        this.outputTimeZone = outputTimeZone;
    }

    @Override
    public boolean isDmyOrder() {
        return this.config.isDmyOrder();
    }

    @Override
    public Map<String, String> getTzMap() {
        return this.config.getTzMap();
    }

    @Override
    public TimeZone getInputTimeZone() {
        return this.inputTimeZone;
    }

    @Override
    public TimeZone getOutputTimeZone() {
        return this.outputTimeZone;
    }

    @Override
    public Locale getLocale() {
        return this.config.getLocale();
    }

    @Override
    public String getFormat() {
        return this.config.getFormat();
    }

    @Override
    public String getBcPrefix() {
        return this.config.getBcPrefix();
    }

    @Override
    public int getEpochDOW() {
        return this.config.getEpochDOW();
    }

    @Override
    public TimeZone lookupTimeZone(String id) {
        return this.config.lookupTimeZone(id, this.inputTimeZone);
    }

    @Override
    public TimeZone lookupTimeZone(String id, TimeZone defaultTimeZone) {
        return this.config.lookupTimeZone(id, defaultTimeZone);
    }

    @Override
    public Integer lookupMonthIndex(String monthNameOrAbbreviation) {
        return this.config.lookupMonthIndex(monthNameOrAbbreviation);
    }

    @Override
    public boolean isUnspecifiedCenturyAlwaysInPast() {
        return this.config.isUnspecifiedCenturyAlwaysInPast();
    }

    @Override
    public long systemTime() {
        return this.config.systemTime();
    }

    @Override
    public void validate() {
        this.config.validate();
    }
}

