/*
 * Decompiled with CFR 0.152.
 */
package org.pojava.datetime;

public class Shift {
    private static final long NPS = 1000000000L;
    private static final long SPM = 60L;
    private static final long MPH = 60L;
    private int year = 0;
    private int month = 0;
    private int week = 0;
    private int day = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private long nanosec = 0L;

    public Shift() {
    }

    public Shift(String iso8601) {
        char[] chars = iso8601.toCharArray();
        double accum = 0.0;
        double dec = 1.0;
        int sign = 1;
        boolean time = false;
        for (char c : chars) {
            if (c == '.') {
                dec /= 10.0;
                continue;
            }
            if (c == '-') {
                sign = -1;
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (dec >= 1.0) {
                    accum = accum * 10.0 + (double)sign * dec * (double)(c - 48);
                    continue;
                }
                accum += (double)sign * dec * (double)(c - 48);
                dec /= 10.0;
                continue;
            }
            if (c == 'T') {
                time = true;
                continue;
            }
            if (c == 'Y') {
                if (accum == 0.0) continue;
                this.shiftYears(accum);
                accum = 0.0;
                dec = 1.0;
                sign = 1;
                continue;
            }
            if (c == 'W') {
                if (accum == 0.0) continue;
                this.shiftWeeks(accum);
                accum = 0.0;
                dec = 1.0;
                sign = 1;
                continue;
            }
            if (c == 'D') {
                if (accum == 0.0) continue;
                this.shiftDays(accum);
                accum = 0.0;
                dec = 1.0;
                sign = 1;
                continue;
            }
            if (c == 'H') {
                if (accum == 0.0) continue;
                this.shiftHours(accum);
                accum = 0.0;
                dec = 1.0;
                sign = 1;
                continue;
            }
            if (c == 'M') {
                if (accum == 0.0) continue;
                if (!time) {
                    this.shiftMonths(accum);
                } else {
                    this.shiftMinutes(accum);
                }
                accum = 0.0;
                dec = 1.0;
                sign = 1;
                continue;
            }
            if (c != 'S' || accum == 0.0) continue;
            this.shiftSeconds(accum);
            accum = 0.0;
            dec = 1.0;
            sign = 1;
        }
    }

    public void shiftYears(double accum) {
        if (accum >= 1.0 || accum <= -1.0) {
            this.year = (int)((long)this.year + (long)accum);
            accum -= (double)((long)accum);
        }
        if (accum != 0.0) {
            this.shiftMonths(accum * 12.0);
        }
    }

    public void shiftMonths(double accum) {
        if (accum >= 1.0 || accum <= -1.0) {
            this.month = (int)((long)this.month + (long)accum);
            accum -= (double)((long)accum);
        }
        if (accum != 0.0) {
            this.shiftDays(accum * 30.0);
        }
    }

    public void shiftWeeks(double accum) {
        if (accum >= 1.0 || accum <= -1.0) {
            this.week = (int)((long)this.week + (long)accum);
            accum -= (double)((long)accum);
        }
        if (accum != 0.0) {
            this.shiftDays(accum * 7.0);
        } else {
            this.settleContents();
        }
    }

    public void shiftDays(double accum) {
        if (accum >= 1.0 || accum <= -1.0) {
            this.day = (int)((long)this.day + (long)accum);
            accum -= (double)((long)accum);
        }
        if (accum != 0.0) {
            this.shiftHours(accum * 24.0);
        } else {
            this.settleContents();
        }
    }

    public void shiftHours(double accum) {
        if (accum >= 1.0 || accum <= -1.0) {
            this.hour = (int)((long)this.hour + (long)accum);
            accum -= (double)((long)accum);
        }
        if (accum != 0.0) {
            this.shiftMinutes(accum * 60.0);
        } else {
            this.settleContents();
        }
    }

    public void shiftMinutes(double accum) {
        if (accum >= 1.0 || accum <= -1.0) {
            this.minute = (int)((long)this.minute + (long)accum);
            accum -= (double)((long)accum);
        }
        if (accum != 0.0) {
            this.shiftSeconds(accum * 60.0);
        } else {
            this.settleContents();
        }
    }

    public void shiftSeconds(double accum) {
        if (accum >= 1.0 || accum <= -1.0) {
            this.second = (int)((long)this.second + (long)accum);
            accum -= (double)((long)accum);
        }
        if (accum != 0.0) {
            this.nanosec += (long)((accum += accum < 0.0 ? -5.0E-10 : 5.0E-10) * 1.0E9);
        }
        this.settleContents();
    }

    private void settleContents() {
        if (this.nanosec >= 1000000000L || this.nanosec <= -1000000000L) {
            long calcsec = this.nanosec / 1000000000L;
            this.second = (int)((long)this.second + calcsec);
            this.nanosec -= calcsec * 1000000000L;
        }
        if ((long)this.second >= 60L || (long)this.second <= -60L) {
            long calcmin = (long)this.second / 60L;
            this.minute = (int)((long)this.minute + calcmin);
            this.second = (int)((long)this.second - calcmin * 60L);
        }
        if ((long)this.minute >= 60L || (long)this.minute <= -60L) {
            long calchour = (long)this.minute / 60L;
            this.hour = (int)((long)this.hour + calchour);
            this.minute = (int)((long)this.minute - calchour * 60L);
        }
        while (this.day < 0 && this.week > 0) {
            --this.week;
            this.day += 7;
        }
        while (this.minute < 0 && this.hour > 0) {
            --this.hour;
            this.minute += 60;
        }
        while (this.second < 0 && this.minute > 0) {
            --this.minute;
            this.second += 60;
        }
        while (this.nanosec < 0L && this.second > 0) {
            --this.second;
            this.nanosec += 1000000000L;
        }
    }

    public String toString() {
        this.settleContents();
        StringBuilder sb = new StringBuilder();
        sb.append('P');
        if (this.year != 0) {
            sb.append(this.year);
            sb.append('Y');
        }
        if (this.month != 0) {
            sb.append(this.month);
            sb.append('M');
        }
        if (this.week != 0) {
            sb.append(this.week);
            sb.append('W');
        }
        if (this.day != 0) {
            sb.append(this.day);
            sb.append('D');
        }
        if (this.hour != 0 || this.minute != 0 || this.second != 0 || this.nanosec != 0L) {
            sb.append('T');
            if (this.hour != 0) {
                sb.append(this.hour);
                sb.append('H');
            }
            if (this.minute != 0) {
                sb.append(this.minute);
                sb.append('M');
            }
            if (this.second != 0 || this.nanosec != 0L) {
                if (this.nanosec == 0L) {
                    sb.append(this.second);
                } else {
                    sb.append((double)this.second + (double)this.nanosec / 1.0E9);
                }
                sb.append('S');
            }
        }
        return sb.toString();
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getWeek() {
        return this.week;
    }

    public void setWeek(int week) {
        this.week = week;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
        this.settleContents();
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int second) {
        this.second = second;
        this.settleContents();
    }

    public int getNanosec() {
        return (int)this.nanosec;
    }

    public void setNanosec(int nanosec) {
        this.nanosec = nanosec;
        this.settleContents();
    }

    public void setNanosec(long nanosec) {
        this.nanosec = nanosec;
        this.settleContents();
    }
}

