/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.agent;

import org.powermock.core.agent.JavaAgentFrameworkRegister;
import org.powermock.reflect.Whitebox;

public class JavaAgentFrameworkRegisterFactory {
    public static JavaAgentFrameworkRegister create() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return JavaAgentFrameworkRegisterFactory.getInstanceForClassLoader(classLoader);
    }

    private static JavaAgentFrameworkRegister getInstanceForClassLoader(ClassLoader classLoader) {
        Class<JavaAgentFrameworkRegister> frameworkReporterClass = JavaAgentFrameworkRegisterFactory.getJavaAgentFrameworkRegisterClass(classLoader);
        return (JavaAgentFrameworkRegister)Whitebox.newInstance(frameworkReporterClass);
    }

    private static Class<JavaAgentFrameworkRegister> getJavaAgentFrameworkRegisterClass(ClassLoader classLoader) {
        Class<JavaAgentFrameworkRegister> agentFrameworkRegisterClass;
        try {
            agentFrameworkRegisterClass = classLoader.loadClass(JavaAgentFrameworkRegisterFactory.getImplementerClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return agentFrameworkRegisterClass;
    }

    private static String getImplementerClassName() {
        return "org.powermock.api.extension.agent.JavaAgentFrameworkRegisterImpl";
    }
}

