/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.javassist.support;

import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.FieldInfo;

public class TransformerHelper {
    public static final String VOID = "";

    private static boolean isAccessFlagSynthetic(CtMethod method) {
        int accessFlags = method.getMethodInfo2().getAccessFlags();
        return (accessFlags & 0x1000) != 0 && !TransformerHelper.isBridgeMethod(method);
    }

    private static boolean isBridgeMethod(CtMethod method) {
        return (method.getMethodInfo2().getAccessFlags() & 0x40) != 0;
    }

    public static String getCorrectReturnValueType(CtClass returnTypeAsCtClass) {
        String returnTypeAsString = returnTypeAsCtClass.getName();
        String returnValue = returnTypeAsCtClass.equals(CtClass.voidType) ? VOID : (returnTypeAsCtClass.isPrimitive() ? (returnTypeAsString.equals("char") ? "((java.lang.Character)value).charValue()" : (returnTypeAsString.equals("boolean") ? "((java.lang.Boolean)value).booleanValue()" : "((java.lang.Number)value)." + returnTypeAsString + "Value()")) : "(" + returnTypeAsString + ")value");
        return returnValue;
    }

    public static boolean isNotSyntheticField(FieldInfo fieldInfo) {
        return (fieldInfo.getAccessFlags() & 0x1000) == 0;
    }

    public static boolean shouldSkipMethod(CtMethod method) {
        return TransformerHelper.isAccessFlagSynthetic(method) || Modifier.isAbstract((int)method.getModifiers());
    }

    public static String getReturnTypeAsString(CtMethod method) throws NotFoundException {
        CtClass returnType = method.getReturnType();
        String returnTypeAsString = VOID;
        if (!returnType.equals(CtClass.voidType)) {
            returnTypeAsString = returnType.getName();
        }
        return returnTypeAsString;
    }

    public static boolean shouldTreatAsSystemClassCall(CtClass declaringClass) {
        String className = declaringClass.getName();
        return className.startsWith("java.");
    }
}

