/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.powermock.core.classloader.ByteCodeFramework;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.MockClassLoaderBuilder;
import org.powermock.core.classloader.annotations.MockPolicy;
import org.powermock.core.classloader.annotations.PrepareEverythingForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.core.classloader.annotations.UseClassPathAdjuster;
import org.powermock.core.spi.PowerMockPolicy;
import org.powermock.core.transformers.MockTransformer;
import org.powermock.tests.utils.ArrayMerger;
import org.powermock.tests.utils.TestClassesExtractor;
import org.powermock.tests.utils.impl.ArrayMergerImpl;
import org.powermock.tests.utils.impl.MockPolicyInitializerImpl;
import org.powermock.tests.utils.impl.PowerMockIgnorePackagesExtractorImpl;
import org.powermock.tests.utils.impl.PrepareForTestExtractorImpl;
import org.powermock.tests.utils.impl.StaticConstructorSuppressExtractorImpl;

public class MockClassLoaderFactory {
    private final String[] packagesToIgnore;
    private final Class<?> testClass;
    private final TestClassesExtractor prepareForTestExtractor;
    private final TestClassesExtractor suppressionExtractor;
    private final ArrayMerger arrayMerger;

    public MockClassLoaderFactory(Class<?> testClass) {
        this(testClass, new PowerMockIgnorePackagesExtractorImpl().getPackagesToIgnore(testClass));
    }

    public MockClassLoaderFactory(Class<?> testClass, String[] packagesToIgnore) {
        this.testClass = testClass;
        this.prepareForTestExtractor = new PrepareForTestExtractorImpl();
        this.suppressionExtractor = new StaticConstructorSuppressExtractorImpl();
        this.packagesToIgnore = packagesToIgnore;
        this.arrayMerger = new ArrayMergerImpl();
    }

    public ClassLoader createForClass(MockTransformer ... extraMockTransformer) {
        ByteCodeFramework byteCodeFramework = ByteCodeFramework.getByteCodeFrameworkForTestClass(this.testClass);
        if (this.testClass.isAnnotationPresent(PrepareEverythingForTest.class)) {
            return this.create(byteCodeFramework, new String[]{"*"}, extraMockTransformer);
        }
        String[] prepareForTestClasses = this.prepareForTestExtractor.getTestClasses(this.testClass);
        String[] suppressStaticClasses = this.suppressionExtractor.getTestClasses(this.testClass);
        return this.create(byteCodeFramework, this.arrayMerger.mergeArrays(String.class, prepareForTestClasses, suppressStaticClasses), extraMockTransformer);
    }

    public ClassLoader createForMethod(Method method, MockTransformer ... extraMockTransformers) {
        ByteCodeFramework byteCodeFramework = ByteCodeFramework.getByteCodeFrameworkForMethod(this.testClass, method);
        if (method.isAnnotationPresent(PrepareEverythingForTest.class)) {
            String[] classesToLoadByMockClassloader = new String[]{"*"};
            return this.create(byteCodeFramework, classesToLoadByMockClassloader, extraMockTransformers);
        }
        String[] suppressStaticClasses = this.getStaticSuppressionClasses(method);
        String[] prepareForTestClasses = this.prepareForTestExtractor.getTestClasses(method);
        String[] classesToLoadByMockClassloader = this.arrayMerger.mergeArrays(String.class, prepareForTestClasses, suppressStaticClasses);
        return this.create(byteCodeFramework, classesToLoadByMockClassloader, extraMockTransformers);
    }

    private ClassLoader create(ByteCodeFramework byteCodeFramework, String[] prepareForTestClasses, MockTransformer ... extraMockTransformer) {
        String[] classesToLoadByMockClassloader = this.makeSureArrayContainsTestClassName(prepareForTestClasses, this.testClass.getName());
        ClassLoader mockLoader = this.isContextClassLoaderShouldBeUsed(classesToLoadByMockClassloader) ? Thread.currentThread().getContextClassLoader() : this.createMockClassLoader(byteCodeFramework, classesToLoadByMockClassloader, extraMockTransformer);
        return mockLoader;
    }

    private String[] getStaticSuppressionClasses(Method method) {
        String[] testClasses = method.isAnnotationPresent(SuppressStaticInitializationFor.class) ? this.suppressionExtractor.getTestClasses(method) : this.suppressionExtractor.getTestClasses(this.testClass);
        return testClasses;
    }

    private ClassLoader createMockClassLoader(ByteCodeFramework byteCodeFramework, String[] classesToLoadByMockClassloader, MockTransformer ... extraMockTransformer) {
        ClassLoader mockLoader = this.createWithPrivilegeAccessController(byteCodeFramework, classesToLoadByMockClassloader, extraMockTransformer);
        this.initialize(mockLoader);
        return mockLoader;
    }

    private ClassLoader createWithPrivilegeAccessController(final ByteCodeFramework byteCodeFramework, final String[] classesToLoadByMockClassloader, final MockTransformer ... extraMockTransformer) {
        return AccessController.doPrivileged(new PrivilegedAction<MockClassLoader>(){

            @Override
            public MockClassLoader run() {
                UseClassPathAdjuster useClassPathAdjuster = MockClassLoaderFactory.this.testClass.getAnnotation(UseClassPathAdjuster.class);
                return MockClassLoaderFactory.this.createMockClassLoader(byteCodeFramework, classesToLoadByMockClassloader, useClassPathAdjuster, extraMockTransformer);
            }
        });
    }

    private MockClassLoader createMockClassLoader(ByteCodeFramework byteCodeFramework, String[] classesToLoadByMockClassloader, UseClassPathAdjuster useClassPathAdjuster, MockTransformer ... extraMockTransformer) {
        return MockClassLoaderBuilder.create(byteCodeFramework).forTestClass(this.testClass).addIgnorePackage(this.packagesToIgnore).addClassesToModify(classesToLoadByMockClassloader).addClassPathAdjuster(useClassPathAdjuster).addExtraMockTransformers(extraMockTransformer).build();
    }

    private void initialize(ClassLoader mockLoader) {
        new MockPolicyInitializerImpl(this.testClass).initialize(mockLoader);
    }

    private boolean isContextClassLoaderShouldBeUsed(String[] classesToLoadByMockClassloader) {
        return (classesToLoadByMockClassloader == null || classesToLoadByMockClassloader.length == 0) && !this.hasMockPolicyProvidedClasses(this.testClass);
    }

    private String[] makeSureArrayContainsTestClassName(String[] arrayOfClassNames, String testClassName) {
        if (null == arrayOfClassNames || 0 == arrayOfClassNames.length) {
            return new String[]{testClassName};
        }
        ArrayList<String> modifiedArrayOfClassNames = new ArrayList<String>(arrayOfClassNames.length + 1);
        modifiedArrayOfClassNames.add(testClassName);
        for (String className : arrayOfClassNames) {
            if (testClassName.equals(className)) {
                return arrayOfClassNames;
            }
            modifiedArrayOfClassNames.add(className);
        }
        return modifiedArrayOfClassNames.toArray(new String[arrayOfClassNames.length + 1]);
    }

    private boolean hasMockPolicyProvidedClasses(Class<?> testClass) {
        boolean hasMockPolicyProvidedClasses = false;
        if (testClass.isAnnotationPresent(MockPolicy.class)) {
            MockPolicy annotation = testClass.getAnnotation(MockPolicy.class);
            Class<? extends PowerMockPolicy>[] value = annotation.value();
            hasMockPolicyProvidedClasses = new MockPolicyInitializerImpl(value).needsInitialization();
        }
        return hasMockPolicyProvidedClasses;
    }
}

