/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.Method;
import org.powermock.core.MockRepository;
import org.powermock.core.spi.PowerMockTestListener;
import org.powermock.core.spi.testresult.Result;
import org.powermock.core.spi.testresult.TestMethodResult;
import org.powermock.core.spi.testresult.TestSuiteResult;
import org.powermock.core.spi.testresult.impl.TestMethodResultImpl;
import org.powermock.tests.utils.PowerMockTestNotifier;

public class PowerMockTestNotifierImpl
implements PowerMockTestNotifier {
    private static final String ERROR_MESSAGE_TEMPLATE = "Invoking the %s method on PowerMock test listener %s failed.";
    private final PowerMockTestListener[] powerMockTestListeners;

    public PowerMockTestNotifierImpl(PowerMockTestListener[] powerMockTestListeners) {
        this.powerMockTestListeners = powerMockTestListeners == null ? new PowerMockTestListener[0] : powerMockTestListeners;
    }

    @Override
    public void notifyAfterTestMethod(Object testInstance, Method method, Object[] arguments, TestMethodResult testResult) {
        for (PowerMockTestListener testListener : this.powerMockTestListeners) {
            try {
                testListener.afterTestMethod(testInstance, method, arguments, testResult);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(ERROR_MESSAGE_TEMPLATE, "afterTestMethod", testListener), e);
            }
        }
    }

    @Override
    public void notifyAfterTestSuiteEnded(Class<?> testClass, Method[] methods, TestSuiteResult testResult) {
        for (PowerMockTestListener powerMockTestListener : this.powerMockTestListeners) {
            try {
                powerMockTestListener.afterTestSuiteEnded(testClass, methods, testResult);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(ERROR_MESSAGE_TEMPLATE, "afterTestSuiteEnded", powerMockTestListener), e);
            }
        }
    }

    @Override
    public void notifyBeforeTestMethod(Object testInstance, Method testMethod, Object[] arguments) {
        MockRepository.putAdditionalState("powermock.test.instance", testInstance);
        MockRepository.putAdditionalState("powermock.test.method", testMethod);
        MockRepository.putAdditionalState("powermock.test.arguments", arguments);
        for (PowerMockTestListener testListener : this.powerMockTestListeners) {
            try {
                testListener.beforeTestMethod(testInstance, testMethod, arguments);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(ERROR_MESSAGE_TEMPLATE, "beforeTestMethod", testListener), e);
            }
        }
    }

    @Override
    public void notifyBeforeTestSuiteStarted(Class<?> testClass, Method[] testMethods) {
        for (PowerMockTestListener powerMockTestListener : this.powerMockTestListeners) {
            try {
                powerMockTestListener.beforeTestSuiteStarted(testClass, testMethods);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(ERROR_MESSAGE_TEMPLATE, "beforeTestSuiteStarted", powerMockTestListener), e);
            }
        }
    }

    @Override
    public void notifyAfterTestMethod(boolean successful) {
        Object test = MockRepository.getAdditionalState("powermock.test.instance");
        Method testMethod = (Method)MockRepository.getAdditionalState("powermock.test.method");
        Object[] testArguments = (Object[])MockRepository.getAdditionalState("powermock.test.arguments");
        TestMethodResultImpl testResult = new TestMethodResultImpl(successful ? Result.SUCCESSFUL : Result.FAILED);
        this.notifyAfterTestMethod(test, testMethod, testArguments, testResult);
    }
}

