/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v96.target.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v96.target.model.SessionID;
import org.openqa.selenium.devtools.v96.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class ReceivedMessageFromTarget {
    private final SessionID sessionId;
    private final String message;
    private final Optional<TargetID> targetId;

    public ReceivedMessageFromTarget(SessionID sessionId, String message, Optional<TargetID> targetId) {
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId is required");
        this.message = Objects.requireNonNull(message, "message is required");
        this.targetId = targetId;
    }

    public SessionID getSessionId() {
        return this.sessionId;
    }

    public String getMessage() {
        return this.message;
    }

    @Deprecated
    public Optional<TargetID> getTargetId() {
        return this.targetId;
    }

    private static ReceivedMessageFromTarget fromJson(JsonInput input) {
        SessionID sessionId = null;
        String message = null;
        Optional<TargetID> targetId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "sessionId": {
                    sessionId = (SessionID)input.read(SessionID.class);
                    continue block10;
                }
                case "message": {
                    message = input.nextString();
                    continue block10;
                }
                case "targetId": {
                    targetId = Optional.ofNullable((TargetID)input.read(TargetID.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ReceivedMessageFromTarget(sessionId, message, targetId);
    }
}

