/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.Token;
import org.spockframework.compiler.AbstractSpecVisitor;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.DeepBlockRewriter;
import org.spockframework.compiler.ErrorReporter;
import org.spockframework.compiler.FieldInitializationExpression;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InstanceFieldAccessChecker;
import org.spockframework.compiler.OldValueExpression;
import org.spockframework.compiler.RecorderScopeNameRewriter;
import org.spockframework.compiler.SourceLookup;
import org.spockframework.compiler.WhereBlockRewriter;
import org.spockframework.compiler.model.AnonymousBlock;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.CleanupBlock;
import org.spockframework.compiler.model.FeatureMethod;
import org.spockframework.compiler.model.Field;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.Spec;
import org.spockframework.compiler.model.ThenBlock;
import org.spockframework.compiler.model.WhenBlock;
import org.spockframework.compiler.model.WhereBlock;
import org.spockframework.runtime.SpecificationContext;
import org.spockframework.util.InternalIdentifiers;
import org.spockframework.util.ObjectUtil;
import org.spockframework.util.ReflectionUtil;

public class SpecRewriter
extends AbstractSpecVisitor
implements IRewriteResources {
    private final AstNodeCache nodeCache;
    private final SourceLookup lookup;
    private final ErrorReporter errorReporter;
    private Spec spec;
    private int specDepth;
    private Method method;
    private Block block;
    private boolean methodHasCondition;
    private boolean movedStatsBackToMethod;
    private boolean thenBlockChainHasExceptionCondition;
    private int fieldInitializerCount = 0;
    private int sharedFieldInitializerCount = 0;
    private int oldValueCount = 0;

    public SpecRewriter(AstNodeCache nodeCache, SourceLookup lookup, ErrorReporter errorReporter) {
        this.nodeCache = nodeCache;
        this.lookup = lookup;
        this.errorReporter = errorReporter;
    }

    @Override
    public void visitSpec(Spec spec) {
        this.spec = spec;
        this.specDepth = this.computeDepth((ClassNode)spec.getAst());
    }

    private int computeDepth(ClassNode node) {
        if (node.equals((Object)ClassHelper.OBJECT_TYPE) || node.equals((Object)this.nodeCache.Specification)) {
            return -1;
        }
        return this.computeDepth(node.getSuperClass()) + 1;
    }

    @Override
    public void visitField(Field field) {
        if (field.isShared()) {
            this.handleSharedField(field);
        } else {
            this.handleNonSharedField(field);
        }
    }

    private void handleSharedField(Field field) {
        this.changeSharedFieldInternalName(field);
        this.createSharedFieldGetter(field);
        this.createSharedFieldSetter(field);
        this.moveSharedFieldInitializer(field);
        SpecRewriter.makeSharedFieldProtectedAndVolatile(field);
    }

    private void changeSharedFieldInternalName(Field field) {
        ((FieldNode)field.getAst()).rename(InternalIdentifiers.getSharedFieldName(field.getName()));
    }

    private void createSharedFieldGetter(Field field) {
        String getterName = "get" + MetaClassHelper.capitalize((String)field.getName());
        MethodNode getter = ((ClassNode)this.spec.getAst()).getMethod(getterName, Parameter.EMPTY_ARRAY);
        if (getter != null) {
            this.errorReporter.error((ASTNode)field.getAst(), "@Shared field '%s' conflicts with method '%s'; please rename either of them", field.getName(), getter.getName());
            return;
        }
        BlockStatement getterBlock = new BlockStatement();
        getter = new MethodNode(getterName, this.determineVisibilityForSharedFieldAccessor(field) | 0x1000, ((FieldNode)field.getAst()).getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)getterBlock);
        getterBlock.addStatement((Statement)new ReturnStatement(new ExpressionStatement((Expression)new AttributeExpression((Expression)this.getSharedInstance(), (Expression)new ConstantExpression((Object)((FieldNode)field.getAst()).getName())))));
        getter.setSourcePosition((ASTNode)field.getAst());
        ((ClassNode)this.spec.getAst()).addMethod(getter);
    }

    private void createSharedFieldSetter(Field field) {
        String setterName = "set" + MetaClassHelper.capitalize((String)field.getName());
        Parameter[] params = new Parameter[]{new Parameter(((FieldNode)field.getAst()).getType(), "$spock_value")};
        MethodNode setter = ((ClassNode)this.spec.getAst()).getMethod(setterName, params);
        if (setter != null) {
            this.errorReporter.error((ASTNode)field.getAst(), "@Shared field '%s' conflicts with method '%s'; please rename either of them", field.getName(), setter.getName());
            return;
        }
        BlockStatement setterBlock = new BlockStatement();
        setter = new MethodNode(setterName, this.determineVisibilityForSharedFieldAccessor(field) | 0x1000, ClassHelper.VOID_TYPE, params, ClassNode.EMPTY_ARRAY, (Statement)setterBlock);
        setterBlock.addStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)new AttributeExpression((Expression)this.getSharedInstance(), (Expression)new ConstantExpression((Object)((FieldNode)field.getAst()).getName())), Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new VariableExpression("$spock_value"))));
        setter.setSourcePosition((ASTNode)field.getAst());
        ((ClassNode)this.spec.getAst()).addMethod(setter);
    }

    private int determineVisibilityForSharedFieldAccessor(Field field) {
        if (field.getOwner() == null) {
            int visibility = AstUtil.getVisibility((FieldNode)field.getAst());
            if (visibility == 2) {
                visibility = 4;
            }
            return visibility;
        }
        return 1;
    }

    private void moveSharedFieldInitializer(Field field) {
        if (((FieldNode)field.getAst()).getInitialValueExpression() != null) {
            this.moveInitializer(field, this.getSharedInitializerMethod(), this.sharedFieldInitializerCount++);
        }
    }

    private static void makeSharedFieldProtectedAndVolatile(Field field) {
        AstUtil.setVisibility((FieldNode)field.getAst(), 4);
        ((FieldNode)field.getAst()).setModifiers(((FieldNode)field.getAst()).getModifiers() | 0x40);
    }

    private void handleNonSharedField(Field field) {
        if (((FieldNode)field.getAst()).getInitialValueExpression() != null) {
            this.moveInitializer(field, this.getInitializerMethod(), this.fieldInitializerCount++);
        }
    }

    private void moveInitializer(Field field, Method method, int position) {
        ((List)method.getFirstBlock().getAst()).add(position, new ExpressionStatement((Expression)new FieldInitializationExpression((FieldNode)field.getAst())));
        ((FieldNode)field.getAst()).setInitialValueExpression(null);
    }

    @Override
    public void visitMethod(Method method) {
        this.method = method;
        this.methodHasCondition = false;
        this.movedStatsBackToMethod = false;
        if (method instanceof FixtureMethod) {
            this.checkFieldAccessInFixtureMethod(method);
            AstUtil.setVisibility((MethodNode)method.getAst(), 2);
        } else if (method instanceof FeatureMethod) {
            this.transplantMethod(method);
            this.handleWhereBlock(method);
        }
    }

    private void checkFieldAccessInFixtureMethod(Method method) {
        if (method != this.spec.getSetupSpecMethod() && method != this.spec.getCleanupSpecMethod()) {
            return;
        }
        new InstanceFieldAccessChecker(this).check(method);
    }

    private void transplantMethod(Method method) {
        FeatureMethod feature = (FeatureMethod)method;
        MethodNode oldAst = (MethodNode)feature.getAst();
        MethodNode newAst = this.copyMethod(oldAst, this.createInternalName(feature));
        ((ClassNode)this.spec.getAst()).addMethod(newAst);
        feature.setAst(newAst);
        AstUtil.deleteMethod((ClassNode)this.spec.getAst(), oldAst);
    }

    private String createInternalName(FeatureMethod feature) {
        return String.format("$spock_feature_%d_%d", this.specDepth, feature.getOrdinal());
    }

    private MethodNode copyMethod(MethodNode method, String newName) {
        MethodNode newMethod = new MethodNode(newName, method.getModifiers(), ClassHelper.VOID_TYPE, method.getParameters(), method.getExceptions(), method.getCode());
        newMethod.addAnnotations(method.getAnnotations());
        newMethod.setSynthetic(method.isSynthetic());
        newMethod.setDeclaringClass(method.getDeclaringClass());
        newMethod.setSourcePosition((ASTNode)method);
        newMethod.setVariableScope(method.getVariableScope());
        newMethod.setGenericsTypes(method.getGenericsTypes());
        newMethod.setAnnotationDefault(method.hasAnnotationDefault());
        return newMethod;
    }

    private void handleWhereBlock(Method method) {
        Block block = method.getLastBlock();
        if (!(block instanceof WhereBlock)) {
            return;
        }
        new DeepBlockRewriter(this).visit(block);
        WhereBlockRewriter.rewrite((WhereBlock)block, this);
    }

    @Override
    public void visitMethodAgain(Method method) {
        this.block = null;
        if (!this.movedStatsBackToMethod) {
            for (Block b : method.getBlocks()) {
                method.getStatements().addAll((Collection)b.getAst());
            }
        }
        if (method instanceof FeatureMethod) {
            method.getStatements().add(this.createMockControllerCall("leaveScope"));
        }
        if (this.methodHasCondition) {
            this.defineRecorders(method.getStatements(), false);
            new RecorderScopeNameRewriter(this.getAstNodeCache()).visitMethod((MethodNode)method.getAst());
        }
    }

    @Override
    public void visitAnyBlock(Block block) {
        this.block = block;
        if (block instanceof ThenBlock) {
            return;
        }
        DeepBlockRewriter deep = new DeepBlockRewriter(this);
        deep.visit(block);
        this.methodHasCondition |= deep.isConditionFound() || deep.isGroupConditionFound();
    }

    @Override
    public void visitThenBlock(ThenBlock block) {
        if (block.isFirstInChain()) {
            this.thenBlockChainHasExceptionCondition = false;
        }
        DeepBlockRewriter deep = new DeepBlockRewriter(this);
        deep.visit(block);
        this.methodHasCondition |= deep.isConditionFound() || deep.isGroupConditionFound();
        if (deep.isExceptionConditionFound()) {
            if (this.thenBlockChainHasExceptionCondition) {
                this.errorReporter.error((ASTNode)deep.getFoundExceptionCondition(), "A chain of 'then' blocks may only have a single exception condition", new Object[0]);
            }
            this.rewriteWhenBlockForExceptionCondition(block.getPrevious(WhenBlock.class));
            this.thenBlockChainHasExceptionCondition = true;
        }
        this.moveInteractions(deep.getThenBlockInteractionStats(), block);
    }

    private void moveInteractions(List<Statement> interactions, ThenBlock block) {
        if (interactions.isEmpty()) {
            return;
        }
        ListIterator listIterator = ((List)block.getAst()).listIterator();
        while (listIterator.hasNext()) {
            Statement next = (Statement)listIterator.next();
            if (!interactions.contains(next)) continue;
            listIterator.remove();
        }
        List statsBeforeWhenBlock = (List)block.getPrevious(WhenBlock.class).getPrevious().getAst();
        statsBeforeWhenBlock.add(this.createMockControllerCall(block.isFirstInChain() ? "enterScope" : "addBarrier"));
        statsBeforeWhenBlock.addAll(interactions);
        if (block.isFirstInChain()) {
            ((List)block.getAst()).add(0, this.createMockControllerCall("leaveScope"));
        }
    }

    private Statement createMockControllerCall(String methodName) {
        return new ExpressionStatement((Expression)new MethodCallExpression((Expression)this.getMockInvocationMatcher(), methodName, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
    }

    @Override
    public void visitCleanupBlock(CleanupBlock block) {
        for (Block b : this.method.getBlocks()) {
            if (b == block) break;
            this.moveVariableDeclarations((List)b.getAst(), this.method.getStatements());
        }
        VariableExpression featureThrowableVar = new VariableExpression("$spock_feature_throwable", this.nodeCache.Throwable);
        this.method.getStatements().add(this.createVariableDeclarationStatement(featureThrowableVar));
        ArrayList featureStats = new ArrayList();
        for (Block b : this.method.getBlocks()) {
            if (b == block) break;
            featureStats.addAll((Collection)b.getAst());
        }
        CatchStatement featureCatchStat = this.createThrowableAssignmentAndRethrowCatchStatement(featureThrowableVar);
        List<TryCatchStatement> cleanupStats = Collections.singletonList(this.createCleanupTryCatch(block, featureThrowableVar));
        TryCatchStatement tryFinally = new TryCatchStatement((Statement)new BlockStatement(featureStats, new VariableScope()), (Statement)new BlockStatement(cleanupStats, new VariableScope()));
        tryFinally.addCatch(featureCatchStat);
        this.method.getStatements().add((Statement)tryFinally);
        this.movedStatsBackToMethod = true;
    }

    private BinaryExpression createVariableNotNullExpression(VariableExpression var) {
        return new BinaryExpression((Expression)new VariableExpression((Variable)var), Token.newSymbol((int)120, (int)-1, (int)-1), (Expression)new ConstantExpression(null));
    }

    private Statement createVariableDeclarationStatement(VariableExpression var) {
        DeclarationExpression throwableDecl = new DeclarationExpression(var, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)EmptyExpression.INSTANCE);
        return new ExpressionStatement((Expression)throwableDecl);
    }

    private TryCatchStatement createCleanupTryCatch(CleanupBlock block, VariableExpression featureThrowableVar) {
        ArrayList cleanupStats = new ArrayList((Collection)block.getAst());
        TryCatchStatement tryCatchStat = new TryCatchStatement((Statement)new BlockStatement(cleanupStats, new VariableScope()), (Statement)EmptyStatement.INSTANCE);
        tryCatchStat.addCatch(this.createHandleSuppressedThrowableStatement(featureThrowableVar));
        return tryCatchStat;
    }

    private CatchStatement createThrowableAssignmentAndRethrowCatchStatement(VariableExpression assignmentVar) {
        Parameter catchParameter = new Parameter(this.nodeCache.Throwable, "$spock_tmp_throwable");
        BinaryExpression assignThrowableExpr = new BinaryExpression((Expression)new VariableExpression((Variable)assignmentVar), Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new VariableExpression((Variable)catchParameter));
        return new CatchStatement(catchParameter, (Statement)new BlockStatement(Arrays.asList(new ExpressionStatement((Expression)assignThrowableExpr), new ThrowStatement((Expression)new VariableExpression((Variable)catchParameter))), new VariableScope()));
    }

    private CatchStatement createHandleSuppressedThrowableStatement(VariableExpression featureThrowableVar) {
        Parameter catchParameter = new Parameter(this.nodeCache.Throwable, "$spock_tmp_throwable");
        MethodCallExpression addSuppressedCall = new MethodCallExpression((Expression)featureThrowableVar, "addSuppressed", (Expression)new ArgumentListExpression((Expression)new VariableExpression((Variable)catchParameter)));
        BinaryExpression featureThrowableNotNullExpr = this.createVariableNotNullExpression(featureThrowableVar);
        List<ExpressionStatement> addSuppressedStats = Collections.singletonList(new ExpressionStatement((Expression)addSuppressedCall));
        List<ThrowStatement> throwFeatureStats = Collections.singletonList(new ThrowStatement((Expression)new VariableExpression((Variable)catchParameter)));
        IfStatement ifFeatureNotNullStat = new IfStatement(new BooleanExpression((Expression)featureThrowableNotNullExpr), (Statement)new BlockStatement(addSuppressedStats, new VariableScope()), (Statement)new BlockStatement(throwFeatureStats, new VariableScope()));
        return new CatchStatement(catchParameter, (Statement)new BlockStatement(Collections.singletonList(ifFeatureNotNullStat), new VariableScope()));
    }

    @Override
    public Spec getCurrentSpec() {
        return this.spec;
    }

    @Override
    public Method getCurrentMethod() {
        return this.method;
    }

    @Override
    public Block getCurrentBlock() {
        return this.block;
    }

    @Override
    public void defineRecorders(List<Statement> stats, boolean enableErrorCollector) {
        ArrayList<Statement> allStats = new ArrayList<Statement>(stats);
        stats.clear();
        stats.add(0, (Statement)new ExpressionStatement((Expression)new DeclarationExpression(new VariableExpression("$spock_valueRecorder", this.nodeCache.ValueRecorder), Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new ConstructorCallExpression(this.nodeCache.ValueRecorder, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS))));
        stats.add(0, (Statement)new ExpressionStatement((Expression)new DeclarationExpression(new VariableExpression("$spock_errorCollector", this.nodeCache.ErrorCollector), Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new ConstructorCallExpression(this.nodeCache.ErrorCollector, (Expression)new ArgumentListExpression(Collections.singletonList(new ConstantExpression((Object)enableErrorCollector, true)))))));
        stats.add((Statement)new TryCatchStatement((Statement)new BlockStatement(allStats, new VariableScope()), (Statement)new ExpressionStatement((Expression)AstUtil.createDirectMethodCall((Expression)new VariableExpression("$spock_errorCollector"), this.nodeCache.ErrorCollector_Validate, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS))));
    }

    @Override
    public VariableExpression captureOldValue(Expression oldValue) {
        OldValueExpression var = new OldValueExpression(oldValue, "$spock_oldValue" + this.oldValueCount++);
        DeclarationExpression decl = new DeclarationExpression((VariableExpression)var, Token.newSymbol((int)100, (int)-1, (int)-1), oldValue);
        decl.setSourcePosition((ASTNode)oldValue);
        ((List)this.block.getPrevious().getPrevious().getAst()).add(new ExpressionStatement((Expression)decl));
        return var;
    }

    public MethodCallExpression getSpecificationContext() {
        return AstUtil.createDirectMethodCall((Expression)VariableExpression.THIS_EXPRESSION, this.nodeCache.SpecInternals_GetSpecificationContext, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
    }

    @Override
    public MethodCallExpression getMockInvocationMatcher() {
        return new MethodCallExpression((Expression)this.getSpecificationContext(), SpecificationContext.GET_MOCK_CONTROLLER, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
    }

    public MethodCallExpression setThrownException(Expression value) {
        return new MethodCallExpression((Expression)this.getSpecificationContext(), SpecificationContext.SET_THROWN_EXCEPTION, (Expression)new ArgumentListExpression(value));
    }

    public MethodCallExpression getSharedInstance() {
        return new MethodCallExpression((Expression)this.getSpecificationContext(), "getSharedInstance", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
    }

    @Override
    public AstNodeCache getAstNodeCache() {
        return this.nodeCache;
    }

    private FixtureMethod getInitializerMethod() {
        if (this.spec.getInitializerMethod() == null) {
            MethodNode gMethod = new MethodNode("$spock_initializeFields", 4098, ClassHelper.DYNAMIC_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement());
            ((ClassNode)this.spec.getAst()).addMethod(gMethod);
            FixtureMethod method = new FixtureMethod(this.spec, gMethod);
            method.addBlock(new AnonymousBlock(method));
            this.spec.setInitializerMethod(method);
        }
        return this.spec.getInitializerMethod();
    }

    @Override
    public String getSourceText(ASTNode node) {
        return this.lookup.lookup(node);
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    private FixtureMethod getSharedInitializerMethod() {
        if (this.spec.getSharedInitializerMethod() == null) {
            MethodNode gMethod = new MethodNode("$spock_initializeSharedFields", 4098, ClassHelper.DYNAMIC_TYPE, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)new BlockStatement());
            ((ClassNode)this.spec.getAst()).addMethod(gMethod);
            FixtureMethod method = new FixtureMethod(this.spec, gMethod);
            method.addBlock(new AnonymousBlock(method));
            this.spec.setSharedInitializerMethod(method);
        }
        return this.spec.getSharedInitializerMethod();
    }

    private void rewriteWhenBlockForExceptionCondition(WhenBlock block) {
        List tryStats = (List)block.getAst();
        ArrayList<Object> blockStats = new ArrayList<Object>();
        block.setAst(blockStats);
        blockStats.add(new ExpressionStatement((Expression)this.setThrownException((Expression)ConstantExpression.NULL)));
        this.moveVariableDeclarations(tryStats, this.method.getStatements());
        TryCatchStatement tryCatchStat = new TryCatchStatement((Statement)new BlockStatement(tryStats, new VariableScope()), (Statement)new BlockStatement());
        blockStats.add(tryCatchStat);
        tryCatchStat.addCatch(new CatchStatement(new Parameter(this.nodeCache.Throwable, "$spock_ex"), (Statement)new BlockStatement(Arrays.asList(new ExpressionStatement((Expression)this.setThrownException((Expression)new VariableExpression("$spock_ex")))), new VariableScope())));
    }

    private void moveVariableDeclarations(List<Statement> from, List<Statement> to) {
        for (Statement stat : from) {
            DeclarationExpression declExpr = AstUtil.getExpression(stat, DeclarationExpression.class);
            if (declExpr == null) continue;
            ((ExpressionStatement)stat).setExpression((Expression)new BinaryExpression(this.copyLhsVariableExpressions(declExpr), Token.newSymbol((int)100, (int)-1, (int)-1), declExpr.getRightExpression()));
            declExpr.setRightExpression(this.createDefaultValueInitializer(declExpr));
            to.add((Statement)new ExpressionStatement((Expression)declExpr));
        }
    }

    private Expression createDefaultValueInitializer(DeclarationExpression expr) {
        TupleExpression tupleExpr = ObjectUtil.asInstance(expr.getLeftExpression(), TupleExpression.class);
        if (tupleExpr == null) {
            return EmptyExpression.INSTANCE;
        }
        assert (expr.isMultipleAssignmentDeclaration());
        ListExpression listExpr = new ListExpression();
        for (Expression elementExpr : tupleExpr.getExpressions()) {
            Variable variable = (Variable)elementExpr;
            listExpr.addExpression((Expression)new ConstantExpression(ReflectionUtil.getDefaultValue(variable.getOriginType().getTypeClass())));
        }
        return listExpr;
    }

    private Expression copyLhsVariableExpressions(DeclarationExpression declExpr) {
        if (declExpr.isMultipleAssignmentDeclaration()) {
            ArgumentListExpression result = new ArgumentListExpression();
            for (Expression expr : declExpr.getTupleExpression().getExpressions()) {
                result.addExpression(this.copyVarExpr((VariableExpression)expr));
            }
            return result;
        }
        return this.copyVarExpr(declExpr.getVariableExpression());
    }

    private Expression copyVarExpr(VariableExpression varExpr) {
        VariableExpression newVarExpr = new VariableExpression(varExpr.getName(), varExpr.getOriginType());
        newVarExpr.setAccessedVariable(varExpr.getAccessedVariable());
        newVarExpr.setSourcePosition((ASTNode)varExpr);
        return newVarExpr;
    }
}

