/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.constraint;

import java.util.regex.Pattern;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.runtime.Condition;
import org.spockframework.util.CollectionUtil;

public class RegexMethodNameConstraint
implements IInvocationConstraint {
    private final Pattern pattern;

    public RegexMethodNameConstraint(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean isSatisfiedBy(IMockInvocation invocation) {
        return this.pattern.matcher(invocation.getMethod().getName()).matches();
    }

    @Override
    public String describeMismatch(IMockInvocation invocation) {
        Condition condition = new Condition(CollectionUtil.listOf(invocation.getMethod().getName(), this.pattern.pattern(), false), String.format("methodName ==~ /%s/", this.pattern.pattern()), null, null, null, null);
        return condition.getRendering();
    }
}

