/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SynchronizationState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.Transformer;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jetbrains.annotations.NotNull;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.codegen.Target;
import org.spockframework.mock.runtime.ByteBuddyInterceptorAdapter;
import org.spockframework.mock.runtime.ByteBuddyInvoker;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.mock.runtime.MockInstantiator;

class ByteBuddyMockFactory {
    private static final TypeCache<TypeCache.SimpleKey> CACHE = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);
    private static final Class<?> CODEGEN_TARGET_CLASS = Target.class;
    private static final String CODEGEN_PACKAGE = CODEGEN_TARGET_CLASS.getPackage().getName();

    ByteBuddyMockFactory() {
    }

    static Object createMock(final Class<?> type, final List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor interceptor, final ClassLoader classLoader, boolean useObjenesis) {
        Class enhancedType = CACHE.findOrInsert(classLoader, (Object)new TypeCache.SimpleKey(type, additionalInterfaces), new Callable<Class<?>>(){

            @Override
            public Class<?> call() throws Exception {
                String typeName = type.getName();
                Class targetClass = type;
                if (ByteBuddyMockFactory.shouldLoadIntoCodegenPackage(type)) {
                    typeName = CODEGEN_PACKAGE + "." + type.getSimpleName();
                    targetClass = CODEGEN_TARGET_CLASS;
                }
                int randomNumber = Math.abs(ThreadLocalRandom.current().nextInt());
                String name = String.format("%s$%s$%d", typeName, "SpockMock", randomNumber);
                ClassLoadingStrategy strategy = ByteBuddyMockFactory.determineBestClassLoadingStrategy(targetClass);
                return new ByteBuddy().with(TypeValidation.DISABLED).ignore((ElementMatcher)ElementMatchers.none()).subclass(type).name(name).implement(additionalInterfaces).implement(new Type[]{ISpockMockObject.class}).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.withDefaultConfiguration().withBinders(new TargetMethodAnnotationDrivenBinder.ParameterBinder[]{Morph.Binder.install(ByteBuddyInvoker.class)}).to(ByteBuddyInterceptorAdapter.class)).transform(Transformer.ForMethod.withModifiers((ModifierContributor.ForMethod[])new ModifierContributor.ForMethod[]{SynchronizationState.PLAIN, Visibility.PUBLIC})).implement(new Type[]{ByteBuddyInterceptorAdapter.InterceptorAccess.class}).intercept((Implementation)FieldAccessor.ofField((String)"$spock_interceptor")).defineField("$spock_interceptor", IProxyBasedMockInterceptor.class, new ModifierContributor.ForField[]{Visibility.PRIVATE}).make().load(classLoader, strategy).getLoaded();
            }
        }, CACHE);
        Object proxy = MockInstantiator.instantiate(type, enhancedType, constructorArgs, useObjenesis);
        ((ByteBuddyInterceptorAdapter.InterceptorAccess)proxy).$spock_set(interceptor);
        return proxy;
    }

    private static boolean shouldLoadIntoCodegenPackage(Class<?> type) {
        return ByteBuddyMockFactory.isComingFromJDK(type) || ByteBuddyMockFactory.isComingFromSignedJar(type) || ByteBuddyMockFactory.isComingFromSealedPackage(type);
    }

    private static boolean isComingFromJDK(Class<?> type) {
        return type.getPackage() != null && "Java Runtime Environment".equalsIgnoreCase(type.getPackage().getImplementationTitle()) || type.getName().startsWith("java.") || type.getName().startsWith("javax.");
    }

    private static boolean isComingFromSealedPackage(Class<?> type) {
        return type.getPackage() != null && type.getPackage().isSealed();
    }

    private static boolean isComingFromSignedJar(Class<?> type) {
        return type.getSigners() != null;
    }

    @NotNull
    private static ClassLoadingStrategy<ClassLoader> determineBestClassLoadingStrategy(Class<?> targetClass) throws Exception {
        if (ClassInjector.UsingLookup.isAvailable()) {
            Class<?> methodHandlesClass = Class.forName("java.lang.invoke.MethodHandles");
            Class<?> lookupClass = Class.forName("java.lang.invoke.MethodHandles$Lookup");
            Method lookupMethod = methodHandlesClass.getMethod("lookup", new Class[0]);
            Method privateLookupInMethod = methodHandlesClass.getMethod("privateLookupIn", Class.class, lookupClass);
            Object lookup = lookupMethod.invoke(null, new Object[0]);
            Object privateLookup = privateLookupInMethod.invoke(null, targetClass, lookup);
            return ClassLoadingStrategy.UsingLookup.of((Object)privateLookup);
        }
        if (ClassInjector.UsingReflection.isAvailable()) {
            return ClassLoadingStrategy.Default.INJECTION;
        }
        return ClassLoadingStrategy.Default.WRAPPER;
    }
}

