/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.util.List;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.runtime.ByteBuddyMockFactory;
import org.spockframework.mock.runtime.CglibMockFactory;
import org.spockframework.mock.runtime.DynamicProxyMockFactory;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.util.ReflectionUtil;

public class ProxyBasedMockFactory {
    private static final boolean ignoreByteBuddy = Boolean.getBoolean("org.spockframework.mock.ignoreByteBuddy");
    private static final boolean byteBuddyAvailable = ReflectionUtil.isClassAvailable("net.bytebuddy.ByteBuddy");
    private static final boolean cglibAvailable = ReflectionUtil.isClassAvailable("net.sf.cglib.proxy.Enhancer");
    public static ProxyBasedMockFactory INSTANCE = new ProxyBasedMockFactory();

    public Object create(Class<?> mockType, List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor mockInterceptor, ClassLoader classLoader, boolean useObjenesis) throws CannotCreateMockException {
        if (mockType.isInterface()) {
            return DynamicProxyMockFactory.createMock(mockType, additionalInterfaces, constructorArgs, mockInterceptor, classLoader);
        }
        if (byteBuddyAvailable && !ignoreByteBuddy) {
            return ByteBuddyMockFactory.createMock(mockType, additionalInterfaces, constructorArgs, mockInterceptor, classLoader, useObjenesis);
        }
        if (cglibAvailable) {
            return CglibMockFactory.createMock(mockType, additionalInterfaces, constructorArgs, mockInterceptor, classLoader, useObjenesis);
        }
        throw new CannotCreateMockException(mockType, ". Mocking of non-interface types requires a code generation library. Please put an up-to-date version of byte-buddy or cglib-nodep on the class path.");
    }
}

