/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.spockframework.runtime.BaseSpecRunner;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.RunStatus;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;

public class ParameterizedSpecRunner
extends BaseSpecRunner {
    public ParameterizedSpecRunner(SpecInfo spec, IRunSupervisor supervisor) {
        super(spec, supervisor);
    }

    @Override
    protected void runParameterizedFeature() {
        if (this.runStatus != 0) {
            return;
        }
        Object[] dataProviders = this.createDataProviders();
        int numIterations = this.estimateNumIterations(dataProviders);
        Iterator[] iterators = this.createIterators(dataProviders);
        this.runIterations(iterators, numIterations);
        this.closeDataProviders(dataProviders);
    }

    private Object[] createDataProviders() {
        if (this.runStatus != 0) {
            return null;
        }
        List<DataProviderInfo> dataProviderInfos = this.currentFeature.getDataProviders();
        Object[] dataProviders = new Object[dataProviderInfos.size()];
        if (!dataProviderInfos.isEmpty()) {
            for (int i = 0; i < dataProviderInfos.size(); ++i) {
                DataProviderInfo dataProviderInfo = dataProviderInfos.get(i);
                MethodInfo method = dataProviderInfo.getDataProviderMethod();
                Object[] arguments = Arrays.copyOf(dataProviders, this.getDataTableOffset(dataProviderInfo));
                Object provider = this.invokeRaw(this.sharedInstance, method, arguments);
                if (this.runStatus != 0) {
                    return null;
                }
                if (provider == null) {
                    SpockExecutionException error = new SpockExecutionException("Data provider is null!");
                    this.runStatus = this.supervisor.error(new ErrorInfo(method, error));
                    return null;
                }
                dataProviders[i] = provider;
            }
        }
        return dataProviders;
    }

    private int getDataTableOffset(DataProviderInfo dataProviderInfo) {
        int result = 0;
        for (String variableName : dataProviderInfo.getDataVariables()) {
            for (String parameterName : this.currentFeature.getParameterNames()) {
                if (variableName.equals(parameterName)) {
                    return result;
                }
                ++result;
            }
        }
        throw new IllegalStateException(String.format("Variable name not defined (%s not in %s)!", dataProviderInfo.getDataVariables(), this.currentFeature.getParameterNames()));
    }

    private Iterator[] createIterators(Object[] dataProviders) {
        if (this.runStatus != 0) {
            return null;
        }
        Iterator[] iterators = new Iterator[dataProviders.length];
        for (int i = 0; i < dataProviders.length; ++i) {
            try {
                Iterator<Object> iter = GroovyRuntimeUtil.asIterator(dataProviders[i]);
                if (iter == null) {
                    this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProviders().get(i).getDataProviderMethod(), new SpockExecutionException("Data provider's iterator() method returned null")));
                    return null;
                }
                iterators[i] = iter;
                continue;
            }
            catch (Throwable t) {
                this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProviders().get(i).getDataProviderMethod(), t));
                return null;
            }
        }
        return iterators;
    }

    private int estimateNumIterations(Object[] dataProviders) {
        if (this.runStatus != 0) {
            return -1;
        }
        if (dataProviders.length == 0) {
            return 1;
        }
        int result = Integer.MAX_VALUE;
        for (Object prov : dataProviders) {
            int size;
            Object rawSize;
            if (prov instanceof Iterator || !((rawSize = GroovyRuntimeUtil.invokeMethodQuietly(prov, "size", new Object[0])) instanceof Number) || (size = ((Number)rawSize).intValue()) < 0 || size >= result) continue;
            result = size;
        }
        return result == Integer.MAX_VALUE ? -1 : result;
    }

    private void runIterations(Iterator[] iterators, int estimatedNumIterations) {
        if (this.runStatus != 0) {
            return;
        }
        while (this.haveNext(iterators)) {
            this.initializeAndRunIteration(this.nextArgs(iterators), estimatedNumIterations);
            if (this.resetStatus(4) == 0 && iterators.length != 0) continue;
            break;
        }
    }

    private void closeDataProviders(Object[] dataProviders) {
        if (RunStatus.action(this.runStatus) == 2) {
            return;
        }
        if (dataProviders == null) {
            return;
        }
        for (Object provider : dataProviders) {
            GroovyRuntimeUtil.invokeMethodQuietly(provider, "close", new Object[0]);
        }
    }

    private boolean haveNext(Iterator[] iterators) {
        if (this.runStatus != 0) {
            return false;
        }
        boolean haveNext = true;
        for (int i = 0; i < iterators.length; ++i) {
            try {
                boolean hasNext = iterators[i].hasNext();
                if (i == 0) {
                    haveNext = hasNext;
                    continue;
                }
                if (haveNext == hasNext) continue;
                DataProviderInfo provider = this.currentFeature.getDataProviders().get(i);
                this.runStatus = this.supervisor.error(new ErrorInfo(provider.getDataProviderMethod(), this.createDifferentNumberOfDataValuesException(provider, hasNext)));
                return false;
            }
            catch (Throwable t) {
                this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProviders().get(i).getDataProviderMethod(), t));
                return false;
            }
        }
        return haveNext;
    }

    private SpockExecutionException createDifferentNumberOfDataValuesException(DataProviderInfo provider, boolean hasNext) {
        String msg = String.format("Data provider for variable '%s' has %s values than previous data provider(s)", provider.getDataVariables().get(0), hasNext ? "more" : "fewer");
        SpockExecutionException exception = new SpockExecutionException(msg);
        FeatureInfo feature = (FeatureInfo)provider.getParent();
        SpecInfo spec = (SpecInfo)feature.getParent();
        StackTraceElement elem = new StackTraceElement(((Class)spec.getReflection()).getName(), feature.getName(), spec.getFilename(), provider.getLine());
        exception.setStackTrace(new StackTraceElement[]{elem});
        return exception;
    }

    private Object[] nextArgs(Iterator[] iterators) {
        if (this.runStatus != 0) {
            return null;
        }
        Object[] next = new Object[iterators.length];
        for (int i = 0; i < iterators.length; ++i) {
            try {
                next[i] = iterators[i].next();
                continue;
            }
            catch (Throwable t) {
                this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProviders().get(i).getDataProviderMethod(), t));
                return null;
            }
        }
        try {
            return (Object[])this.invokeRaw(this.sharedInstance, this.currentFeature.getDataProcessorMethod(), next);
        }
        catch (Throwable t) {
            this.runStatus = this.supervisor.error(new ErrorInfo(this.currentFeature.getDataProcessorMethod(), t));
            return null;
        }
    }
}

