/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.AbstractSwaggerUiConfigProperties;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractSwaggerWelcome {
    protected final SwaggerUiConfigProperties swaggerUiConfig;
    protected final SpringDocConfigProperties springDocConfigProperties;
    protected final SwaggerUiConfigParameters swaggerUiConfigParameters;
    protected String swaggerConfigUrl;
    protected String apiDocsUrl;
    protected String contextPath;

    public AbstractSwaggerWelcome(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.springDocConfigProperties = springDocConfigProperties;
        this.swaggerUiConfigParameters = swaggerUiConfigParameters;
    }

    protected void init() {
        this.springDocConfigProperties.getGroupConfigs().forEach(groupConfig -> this.swaggerUiConfigParameters.addGroup(groupConfig.getGroup(), groupConfig.getDisplayName()));
        this.calculateUiRootPath(new StringBuilder[0]);
    }

    protected String buildUrl(String contextPath, String docsUrl) {
        if (contextPath.endsWith("/")) {
            return contextPath.substring(0, contextPath.length() - 1) + docsUrl;
        }
        if (!docsUrl.startsWith("/")) {
            docsUrl = "/" + docsUrl;
        }
        return contextPath + docsUrl;
    }

    protected void buildConfigUrl(UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isEmpty((CharSequence)this.swaggerUiConfig.getConfigUrl())) {
            this.apiDocsUrl = this.buildApiDocUrl();
            this.swaggerConfigUrl = this.buildSwaggerConfigUrl();
            this.swaggerUiConfigParameters.setConfigUrl(this.swaggerConfigUrl);
            if (CollectionUtils.isEmpty(this.swaggerUiConfigParameters.getUrls())) {
                String swaggerUiUrl = this.swaggerUiConfig.getUrl();
                if (StringUtils.isEmpty((CharSequence)swaggerUiUrl)) {
                    this.swaggerUiConfigParameters.setUrl(this.apiDocsUrl);
                } else if (this.swaggerUiConfigParameters.isValidUrl(swaggerUiUrl)) {
                    this.swaggerUiConfigParameters.setUrl(swaggerUiUrl);
                } else {
                    this.swaggerUiConfigParameters.setUrl(this.buildUrlWithContextPath(swaggerUiUrl));
                }
            } else {
                this.swaggerUiConfigParameters.addUrl(this.apiDocsUrl);
            }
            if (!CollectionUtils.isEmpty(this.swaggerUiConfig.getUrls())) {
                this.swaggerUiConfig.cloneUrls().forEach(swaggerUrl -> {
                    this.swaggerUiConfigParameters.getUrls().remove(swaggerUrl);
                    if (!this.swaggerUiConfigParameters.isValidUrl(swaggerUrl.getUrl())) {
                        swaggerUrl.setUrl(this.buildUrlWithContextPath(swaggerUrl.getUrl()));
                    }
                    this.swaggerUiConfigParameters.getUrls().add((AbstractSwaggerUiConfigProperties.SwaggerUrl)swaggerUrl);
                });
            }
        }
        this.calculateOauth2RedirectUrl(uriComponentsBuilder);
    }

    protected abstract String buildUrlWithContextPath(String var1);

    protected UriComponentsBuilder getUriComponentsBuilder(String sbUrl) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)sbUrl);
        if (this.swaggerUiConfig.getQueryConfigEnabled() != null && this.swaggerUiConfig.getQueryConfigEnabled().booleanValue()) {
            this.swaggerUiConfigParameters.getConfigParameters().entrySet().stream().filter(entry -> !"configUrl".equals(entry.getKey())).filter(entry -> !"oauth2RedirectUrl".equals(entry.getKey())).filter(entry -> !"url".equals(entry.getKey())).filter(entry -> !((String)entry.getKey()).startsWith("urls")).filter(entry -> entry.getValue() instanceof String ? StringUtils.isNotEmpty((CharSequence)((String)entry.getValue())) : entry.getValue() != null).forEach(entry -> uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()}));
            uriBuilder.queryParam("configUrl", new Object[]{this.swaggerUiConfigParameters.getConfigUrl()});
        }
        return uriBuilder;
    }

    protected abstract void calculateOauth2RedirectUrl(UriComponentsBuilder var1);

    protected abstract void calculateUiRootPath(StringBuilder ... var1);

    protected void calculateUiRootCommon(StringBuilder sbUrl, StringBuilder[] sbUrls) {
        String swaggerPath;
        if (ArrayUtils.isNotEmpty((Object[])sbUrls)) {
            sbUrl = sbUrls[0];
        }
        if ((swaggerPath = this.swaggerUiConfigParameters.getPath()).contains("/")) {
            sbUrl.append(swaggerPath, 0, swaggerPath.lastIndexOf("/"));
        }
        this.swaggerUiConfigParameters.setUiRootPath(sbUrl.toString());
    }

    protected abstract String buildApiDocUrl();

    protected abstract String buildSwaggerConfigUrl();

    protected String getOauth2RedirectUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl(), (CharSequence)"/swagger-ui/oauth2-redirect.html");
    }

    protected String getSwaggerUiUrl() {
        return "/swagger-ui/index.html";
    }
}

