/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.util.StringUtils;

public class JsrExpressionParser {
    private static final String QUOTE = "'";
    private static final String NULL = "null";
    private static final String ELVIS_RHS = ":";
    private static final String ELVIS_LHS = "\\?";
    private static final String ELVIS_OPERATOR = "?:";
    private static final String EXPRESSION_SUFFIX = "}";
    private static final String EXPRESSION_PREFIX = "#{";
    private static final String DEFAULT_VALUE_SEPARATOR = ";";
    private static final Pattern CONDITIONAL_EXPRESSION = Pattern.compile("(((\\bnull\\b)|(#\\{\\w))[^;]+)");
    private BeanExpressionContext beanExpressionContext;
    private BeanExpressionResolver beanExpressionResolver;

    public JsrExpressionParser() {
    }

    public JsrExpressionParser(BeanExpressionResolver beanExpressionResolver, BeanExpressionContext beanExpressionContext) {
        this.beanExpressionContext = beanExpressionContext;
        this.beanExpressionResolver = beanExpressionResolver;
    }

    public String parseExpression(String expression) {
        String expressionToParse = expression;
        if (StringUtils.countOccurrencesOf((String)expressionToParse, (String)ELVIS_OPERATOR) > 0) {
            expressionToParse = this.parseConditionalExpressions(expressionToParse);
        }
        return this.evaluateExpression(expressionToParse);
    }

    private String parseConditionalExpressions(String expression) {
        String expressionToParse = expression;
        Matcher conditionalExpressionMatcher = CONDITIONAL_EXPRESSION.matcher(expressionToParse);
        while (conditionalExpressionMatcher.find()) {
            String conditionalExpression = conditionalExpressionMatcher.group(1);
            String value = conditionalExpression.split(ELVIS_LHS)[0];
            String defaultValue = conditionalExpression.split(ELVIS_RHS)[1];
            StringBuilder parsedExpression = new StringBuilder();
            if (this.beanExpressionResolver != null) {
                parsedExpression.append(EXPRESSION_PREFIX).append(this.evaluateExpression(value)).append(ELVIS_OPERATOR).append(QUOTE).append(this.evaluateExpression(defaultValue)).append(QUOTE).append(EXPRESSION_SUFFIX);
            } else if (NULL.equals(value)) {
                parsedExpression.append(defaultValue);
            } else {
                parsedExpression.append(value);
            }
            expressionToParse = expressionToParse.replace(conditionalExpression, parsedExpression);
        }
        return expressionToParse.replace(DEFAULT_VALUE_SEPARATOR, "");
    }

    private String evaluateExpression(String expression) {
        if (this.beanExpressionResolver != null) {
            return (String)this.beanExpressionResolver.evaluate(expression, this.beanExpressionContext);
        }
        return expression;
    }
}

