/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.annotation;

import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.configuration.annotation.DefaultBatchConfigurer;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.ScopeConfiguration;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.configuration.support.MapJobRegistry;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@Import(value={ScopeConfiguration.class})
public abstract class AbstractBatchConfiguration
implements ImportAware,
InitializingBean {
    @Autowired(required=false)
    private DataSource dataSource;
    private BatchConfigurer configurer;
    private JobRegistry jobRegistry = new MapJobRegistry();
    private JobBuilderFactory jobBuilderFactory;
    private StepBuilderFactory stepBuilderFactory;

    @Bean
    public JobBuilderFactory jobBuilders() throws Exception {
        return this.jobBuilderFactory;
    }

    @Bean
    public StepBuilderFactory stepBuilders() throws Exception {
        return this.stepBuilderFactory;
    }

    @Bean
    public abstract JobRepository jobRepository() throws Exception;

    @Bean
    public abstract JobLauncher jobLauncher() throws Exception;

    @Bean
    public abstract JobExplorer jobExplorer() throws Exception;

    @Bean
    public JobRegistry jobRegistry() throws Exception {
        return this.jobRegistry;
    }

    @Bean
    public abstract PlatformTransactionManager transactionManager() throws Exception;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes enabled = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableBatchProcessing.class.getName(), false));
        Assert.notNull((Object)enabled, (String)("@EnableBatchProcessing is not present on importing class " + importMetadata.getClassName()));
    }

    public void afterPropertiesSet() throws Exception {
        this.jobBuilderFactory = new JobBuilderFactory(this.jobRepository());
        this.stepBuilderFactory = new StepBuilderFactory(this.jobRepository(), this.transactionManager());
    }

    protected BatchConfigurer getConfigurer(Collection<BatchConfigurer> configurers) throws Exception {
        if (this.configurer != null) {
            return this.configurer;
        }
        if (configurers == null || configurers.isEmpty()) {
            if (this.dataSource == null) {
                DefaultBatchConfigurer configurer = new DefaultBatchConfigurer();
                configurer.initialize();
                this.configurer = configurer;
                return configurer;
            }
            DefaultBatchConfigurer configurer = new DefaultBatchConfigurer(this.dataSource);
            configurer.initialize();
            this.configurer = configurer;
            return configurer;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("To use a custom BatchConfigurer the context must contain precisely one, found " + configurers.size());
        }
        this.configurer = configurers.iterator().next();
        return this.configurer;
    }
}

