/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.springframework.batch.core.configuration.xml.AbstractFlowParser;
import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class TopLevelFlowParser
extends AbstractFlowParser {
    private static final String ABSTRACT_ATTR = "abstract";

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        CoreNamespaceUtils.autoregisterBeansForNamespace(parserContext, element);
        String flowName = element.getAttribute("id");
        builder.getRawBeanDefinition().setAttribute("flowName", (Object)flowName);
        builder.addPropertyValue("name", (Object)flowName);
        builder.addPropertyValue("stateTransitionComparator", (Object)new RuntimeBeanReference("batch_state_transition_comparator"));
        String abstractAttr = element.getAttribute(ABSTRACT_ATTR);
        if (StringUtils.hasText((String)abstractAttr)) {
            builder.setAbstract(abstractAttr.equals("true"));
        }
        super.doParse(element, parserContext, builder);
    }
}

