/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.io.Serializable;
import java.util.Date;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.Metric;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.jsr.JsrStepContext;
import org.springframework.batch.core.jsr.SimpleMetric;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JsrStepExecution
implements javax.batch.runtime.StepExecution {
    private static final String PERSISTENT_USER_DATA_KEY = "batch_jsr_persistentUserData";
    private final StepExecution stepExecution;
    private final ExecutionContextUserSupport executionContextUserSupport = new ExecutionContextUserSupport(ClassUtils.getShortName(JsrStepContext.class));

    public JsrStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution, (String)"A StepExecution is required");
        this.stepExecution = stepExecution;
    }

    public long getStepExecutionId() {
        return this.stepExecution.getId();
    }

    public String getStepName() {
        return this.stepExecution.getStepName();
    }

    public BatchStatus getBatchStatus() {
        return this.stepExecution.getStatus().getBatchStatus();
    }

    public Date getStartTime() {
        return this.stepExecution.getStartTime();
    }

    public Date getEndTime() {
        return this.stepExecution.getEndTime();
    }

    public String getExitStatus() {
        ExitStatus status = this.stepExecution.getExitStatus();
        if (status == null) {
            return null;
        }
        return status.getExitCode();
    }

    public Serializable getPersistentUserData() {
        return (Serializable)this.stepExecution.getExecutionContext().get(this.executionContextUserSupport.getKey(PERSISTENT_USER_DATA_KEY));
    }

    public Metric[] getMetrics() {
        Metric[] metrics = new Metric[]{new SimpleMetric(Metric.MetricType.COMMIT_COUNT, this.stepExecution.getCommitCount()), new SimpleMetric(Metric.MetricType.FILTER_COUNT, this.stepExecution.getFilterCount()), new SimpleMetric(Metric.MetricType.PROCESS_SKIP_COUNT, this.stepExecution.getProcessSkipCount()), new SimpleMetric(Metric.MetricType.READ_COUNT, this.stepExecution.getReadCount()), new SimpleMetric(Metric.MetricType.READ_SKIP_COUNT, this.stepExecution.getReadSkipCount()), new SimpleMetric(Metric.MetricType.ROLLBACK_COUNT, this.stepExecution.getRollbackCount()), new SimpleMetric(Metric.MetricType.WRITE_COUNT, this.stepExecution.getWriteCount()), new SimpleMetric(Metric.MetricType.WRITE_SKIP_COUNT, this.stepExecution.getWriteSkipCount())};
        return metrics;
    }
}

