/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ReaderNotOpenException;
import org.springframework.batch.item.database.ExtendedConnectionDataSourceProxy;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.jdbc.SQLWarningException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class AbstractCursorItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final int VALUE_NOT_SET = -1;
    private Connection con;
    protected ResultSet rs;
    private DataSource dataSource;
    private int fetchSize = -1;
    private int maxRows = -1;
    private int queryTimeout = -1;
    private boolean ignoreWarnings = true;
    private boolean verifyCursorPosition = true;
    private SQLExceptionTranslator exceptionTranslator;
    private boolean initialized = false;
    private boolean driverSupportsAbsolute = false;
    private boolean useSharedExtendedConnection = false;
    private Boolean connectionAutoCommit;
    private boolean initialConnectionAutoCommit;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"DataSource must be provided");
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void applyStatementSettings(PreparedStatement stmt) throws SQLException {
        if (this.fetchSize != -1) {
            stmt.setFetchSize(this.fetchSize);
            stmt.setFetchDirection(1000);
        }
        if (this.maxRows != -1) {
            stmt.setMaxRows(this.maxRows);
        }
        if (this.queryTimeout != -1) {
            stmt.setQueryTimeout(this.queryTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SQLExceptionTranslator getExceptionTranslator() {
        AbstractCursorItemReader abstractCursorItemReader = this;
        synchronized (abstractCursorItemReader) {
            if (this.exceptionTranslator == null) {
                this.exceptionTranslator = this.dataSource != null ? new SQLErrorCodeSQLExceptionTranslator(this.dataSource) : new SQLStateSQLExceptionTranslator();
            }
        }
        return this.exceptionTranslator;
    }

    protected void handleWarnings(Statement statement) throws SQLWarningException, SQLException {
        if (this.ignoreWarnings) {
            if (this.log.isDebugEnabled()) {
                for (SQLWarning warningToLog = statement.getWarnings(); warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                    this.log.debug((Object)("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "]"));
                }
            }
        } else {
            SQLWarning warnings = statement.getWarnings();
            if (warnings != null) {
                throw new SQLWarningException("Warning not ignored", warnings);
            }
        }
    }

    private void moveCursorToRow(int row) {
        try {
            for (int count = 0; row != count && this.rs.next(); ++count) {
            }
        }
        catch (SQLException se) {
            throw this.getExceptionTranslator().translate("Attempted to move ResultSet to last committed row", this.getSql(), se);
        }
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public void setVerifyCursorPosition(boolean verifyCursorPosition) {
        this.verifyCursorPosition = verifyCursorPosition;
    }

    public void setDriverSupportsAbsolute(boolean driverSupportsAbsolute) {
        this.driverSupportsAbsolute = driverSupportsAbsolute;
    }

    public void setUseSharedExtendedConnection(boolean useSharedExtendedConnection) {
        this.useSharedExtendedConnection = useSharedExtendedConnection;
    }

    public boolean isUseSharedExtendedConnection() {
        return this.useSharedExtendedConnection;
    }

    public void setConnectionAutoCommit(boolean autoCommit) {
        this.connectionAutoCommit = autoCommit;
    }

    public abstract String getSql();

    private void verifyCursorPosition(long expectedCurrentRow) throws SQLException {
        if (this.verifyCursorPosition && expectedCurrentRow != (long)this.rs.getRow()) {
            throw new InvalidDataAccessResourceUsageException("Unexpected cursor position change.");
        }
    }

    @Override
    protected void doClose() throws Exception {
        this.initialized = false;
        JdbcUtils.closeResultSet((ResultSet)this.rs);
        this.rs = null;
        this.cleanupOnClose();
        if (this.con != null) {
            this.con.setAutoCommit(this.initialConnectionAutoCommit);
        }
        if (this.useSharedExtendedConnection && this.dataSource instanceof ExtendedConnectionDataSourceProxy) {
            ((ExtendedConnectionDataSourceProxy)((Object)this.dataSource)).stopCloseSuppression(this.con);
            if (!TransactionSynchronizationManager.isActualTransactionActive()) {
                DataSourceUtils.releaseConnection((Connection)this.con, (DataSource)this.dataSource);
            }
        } else {
            JdbcUtils.closeConnection((Connection)this.con);
        }
    }

    protected abstract void cleanupOnClose() throws Exception;

    @Override
    protected void doOpen() throws Exception {
        Assert.state((!this.initialized ? 1 : 0) != 0, (String)"Stream is already initialized.  Close before re-opening.");
        Assert.isNull((Object)this.rs, (String)"ResultSet still open!  Close before re-opening.");
        this.initializeConnection();
        this.openCursor(this.con);
        this.initialized = true;
    }

    protected void initializeConnection() {
        Assert.state((this.getDataSource() != null ? 1 : 0) != 0, (String)"DataSource must not be null.");
        try {
            if (this.useSharedExtendedConnection) {
                if (!(this.getDataSource() instanceof ExtendedConnectionDataSourceProxy)) {
                    throw new InvalidDataAccessApiUsageException("You must use a ExtendedConnectionDataSourceProxy for the dataSource when useSharedExtendedConnection is set to true.");
                }
                this.con = DataSourceUtils.getConnection((DataSource)this.dataSource);
                ((ExtendedConnectionDataSourceProxy)((Object)this.dataSource)).startCloseSuppression(this.con);
            } else {
                this.con = this.dataSource.getConnection();
            }
            this.initialConnectionAutoCommit = this.con.getAutoCommit();
            if (this.connectionAutoCommit != null && this.con.getAutoCommit() != this.connectionAutoCommit.booleanValue()) {
                this.con.setAutoCommit(this.connectionAutoCommit);
            }
        }
        catch (SQLException se) {
            this.close();
            throw this.getExceptionTranslator().translate("Executing query", this.getSql(), se);
        }
    }

    protected abstract void openCursor(Connection var1);

    @Override
    @Nullable
    protected T doRead() throws Exception {
        if (this.rs == null) {
            throw new ReaderNotOpenException("Reader must be open before it can be read.");
        }
        try {
            if (!this.rs.next()) {
                return null;
            }
            int currentRow = this.getCurrentItemCount();
            T item = this.readCursor(this.rs, currentRow);
            this.verifyCursorPosition(currentRow);
            return item;
        }
        catch (SQLException se) {
            throw this.getExceptionTranslator().translate("Attempt to process next row failed", this.getSql(), se);
        }
    }

    @Nullable
    protected abstract T readCursor(ResultSet var1, int var2) throws SQLException;

    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        if (this.driverSupportsAbsolute) {
            try {
                this.rs.absolute(itemIndex);
            }
            catch (SQLException e) {
                this.log.warn((Object)"The JDBC driver does not appear to support ResultSet.absolute(). Consider reverting to the default behavior setting the driverSupportsAbsolute to false", (Throwable)e);
                this.moveCursorToRow(itemIndex);
            }
        } else {
            this.moveCursorToRow(itemIndex);
        }
    }
}

