/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.AccessLevel;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.SecurityResponse;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.CloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.reactive.AbstractWebFluxEndpointHandlerMapping;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

class CloudFoundryWebFluxEndpointHandlerMapping
extends AbstractWebFluxEndpointHandlerMapping {
    private final CloudFoundrySecurityInterceptor securityInterceptor;
    private final EndpointLinksResolver linksResolver;

    CloudFoundryWebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<ExposableWebEndpoint> endpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration, CloudFoundrySecurityInterceptor securityInterceptor, EndpointLinksResolver linksResolver) {
        super(endpointMapping, endpoints, endpointMediaTypes, corsConfiguration);
        this.linksResolver = linksResolver;
        this.securityInterceptor = securityInterceptor;
    }

    protected AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation wrapReactiveWebOperation(ExposableWebEndpoint endpoint, WebOperation operation, AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation reactiveWebOperation) {
        return new SecureReactiveWebOperation(reactiveWebOperation, this.securityInterceptor, endpoint.getId());
    }

    @ResponseBody
    protected Publisher<ResponseEntity<Object>> links(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        return this.securityInterceptor.preHandle(exchange, "").map(securityResponse -> {
            if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
                return new ResponseEntity(securityResponse.getStatus());
            }
            AccessLevel accessLevel = (AccessLevel)((Object)((Object)exchange.getAttribute("cloudFoundryAccessLevel")));
            Map links = this.linksResolver.resolveLinks(request.getURI().toString());
            return new ResponseEntity(Collections.singletonMap("_links", this.getAccessibleLinks(accessLevel, links)), HttpStatus.OK);
        });
    }

    private Map<String, Link> getAccessibleLinks(AccessLevel accessLevel, Map<String, Link> links) {
        if (accessLevel == null) {
            return new LinkedHashMap<String, Link>();
        }
        return links.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("self") || accessLevel.isAccessAllowed((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static class SecureReactiveWebOperation
    implements AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation {
        private final AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation delegate;
        private final CloudFoundrySecurityInterceptor securityInterceptor;
        private final String endpointId;

        SecureReactiveWebOperation(AbstractWebFluxEndpointHandlerMapping.ReactiveWebOperation delegate, CloudFoundrySecurityInterceptor securityInterceptor, String endpointId) {
            this.delegate = delegate;
            this.securityInterceptor = securityInterceptor;
            this.endpointId = endpointId;
        }

        public Mono<ResponseEntity<Object>> handle(ServerWebExchange exchange, Map<String, String> body) {
            return this.securityInterceptor.preHandle(exchange, this.endpointId).flatMap(securityResponse -> this.flatMapResponse(exchange, body, (SecurityResponse)securityResponse));
        }

        private Mono<ResponseEntity<Object>> flatMapResponse(ServerWebExchange exchange, Map<String, String> body, SecurityResponse securityResponse) {
            if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
                return Mono.just((Object)new ResponseEntity(securityResponse.getStatus()));
            }
            return this.delegate.handle(exchange, body);
        }
    }
}

