/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cassandra;

import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class CassandraReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final ReactiveCassandraOperations reactiveCassandraOperations;

    public CassandraReactiveHealthIndicator(ReactiveCassandraOperations reactiveCassandraOperations) {
        Assert.notNull((Object)reactiveCassandraOperations, (String)"ReactiveCassandraOperations must not be null");
        this.reactiveCassandraOperations = reactiveCassandraOperations;
    }

    @Override
    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        Select select = QueryBuilder.select((String[])new String[]{"release_version"}).from("system", "local");
        return this.reactiveCassandraOperations.getReactiveCqlOperations().queryForObject((Statement)select, String.class).map(version -> builder.up().withDetail("version", version).build()).single();
    }
}

