/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.boot.actuate.endpoint.OperationArgumentResolver;
import org.springframework.boot.actuate.endpoint.Producible;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class ProducibleOperationArgumentResolver
implements OperationArgumentResolver {
    private final Supplier<List<String>> accepts;

    public ProducibleOperationArgumentResolver(Supplier<List<String>> accepts) {
        this.accepts = accepts;
    }

    @Override
    public boolean canResolve(Class<?> type) {
        return Producible.class.isAssignableFrom(type) && Enum.class.isAssignableFrom(type);
    }

    @Override
    public <T> T resolve(Class<T> type) {
        return (T)this.resolveProducible(type);
    }

    private Enum<? extends Producible<?>> resolveProducible(Class<Enum<? extends Producible<?>>> type) {
        List<String> accepts = this.accepts.get();
        List<Enum<Producible<?>>> values = Arrays.asList(type.getEnumConstants());
        Collections.reverse(values);
        if (CollectionUtils.isEmpty(accepts)) {
            return values.get(0);
        }
        Enum<? extends Producible<?>> result = null;
        for (String accept : accepts) {
            for (String mimeType : MimeTypeUtils.tokenize((String)accept)) {
                result = ProducibleOperationArgumentResolver.mostRecent(result, ProducibleOperationArgumentResolver.forType(values, MimeTypeUtils.parseMimeType((String)mimeType)));
            }
        }
        return result;
    }

    private static Enum<? extends Producible<?>> mostRecent(Enum<? extends Producible<?>> existing, Enum<? extends Producible<?>> candidate) {
        int existingOrdinal = existing != null ? existing.ordinal() : -1;
        int candidateOrdinal = candidate != null ? candidate.ordinal() : -1;
        return candidateOrdinal > existingOrdinal ? candidate : existing;
    }

    private static Enum<? extends Producible<?>> forType(List<Enum<? extends Producible<?>>> candidates, MimeType mimeType) {
        for (Enum<Producible<?>> enum_ : candidates) {
            if (!mimeType.isCompatibleWith(((Producible)((Object)enum_)).getProducedMimeType())) continue;
            return enum_;
        }
        return null;
    }
}

