/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.servlet;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.security.StaticResourceLocation;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class StaticResourceRequest {
    static final StaticResourceRequest INSTANCE = new StaticResourceRequest();

    private StaticResourceRequest() {
    }

    public StaticResourceRequestMatcher atCommonLocations() {
        return this.at(EnumSet.allOf(StaticResourceLocation.class));
    }

    public StaticResourceRequestMatcher at(StaticResourceLocation first, StaticResourceLocation ... rest) {
        return this.at(EnumSet.of(first, rest));
    }

    public StaticResourceRequestMatcher at(Set<StaticResourceLocation> locations) {
        Assert.notNull(locations, (String)"Locations must not be null");
        return new StaticResourceRequestMatcher(new LinkedHashSet<StaticResourceLocation>(locations));
    }

    public static final class StaticResourceRequestMatcher
    extends ApplicationContextRequestMatcher<ServerProperties> {
        private final Set<StaticResourceLocation> locations;
        private RequestMatcher delegate;

        private StaticResourceRequestMatcher(Set<StaticResourceLocation> locations) {
            super(ServerProperties.class);
            this.locations = locations;
        }

        public StaticResourceRequestMatcher excluding(StaticResourceLocation first, StaticResourceLocation ... rest) {
            return this.excluding(EnumSet.of(first, rest));
        }

        public StaticResourceRequestMatcher excluding(Set<StaticResourceLocation> locations) {
            Assert.notNull(locations, (String)"Locations must not be null");
            LinkedHashSet<StaticResourceLocation> subset = new LinkedHashSet<StaticResourceLocation>(this.locations);
            subset.removeAll(locations);
            return new StaticResourceRequestMatcher(subset);
        }

        protected void initialized(Supplier<ServerProperties> serverProperties) {
            this.delegate = new OrRequestMatcher(this.getDelegateMatchers(serverProperties.get()));
        }

        private List<RequestMatcher> getDelegateMatchers(ServerProperties serverProperties) {
            return this.getPatterns(serverProperties).map(AntPathRequestMatcher::new).collect(Collectors.toList());
        }

        private Stream<String> getPatterns(ServerProperties serverProperties) {
            return this.locations.stream().flatMap(StaticResourceLocation::getPatterns).map(serverProperties.getServlet()::getPath);
        }

        protected boolean matches(HttpServletRequest request, Supplier<ServerProperties> context) {
            return this.delegate.matches(request);
        }
    }
}

