/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.util.Arrays;
import java.util.HashSet;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractDependsOnBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private final Class<?> beanClass;
    private final Class<? extends FactoryBean<?>> factoryBeanClass;
    private final String[] dependsOn;

    protected AbstractDependsOnBeanFactoryPostProcessor(Class<?> beanClass, Class<? extends FactoryBean<?>> factoryBeanClass, String ... dependsOn) {
        this.beanClass = beanClass;
        this.factoryBeanClass = factoryBeanClass;
        this.dependsOn = dependsOn;
    }

    protected AbstractDependsOnBeanFactoryPostProcessor(Class<?> beanClass, String ... dependsOn) {
        this(beanClass, (Class<? extends FactoryBean<?>>)null, dependsOn);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        for (String beanName : this.getBeanNames((ListableBeanFactory)beanFactory)) {
            BeanDefinition definition = AbstractDependsOnBeanFactoryPostProcessor.getBeanDefinition(beanName, beanFactory);
            String[] dependencies = definition.getDependsOn();
            for (String bean : this.dependsOn) {
                dependencies = StringUtils.addStringToArray((String[])dependencies, (String)bean);
            }
            definition.setDependsOn(dependencies);
        }
    }

    private Iterable<String> getBeanNames(ListableBeanFactory beanFactory) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, this.beanClass, (boolean)true, (boolean)false)));
        if (this.factoryBeanClass != null) {
            for (String factoryBeanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, this.factoryBeanClass, (boolean)true, (boolean)false)) {
                names.add(BeanFactoryUtils.transformedBeanName((String)factoryBeanName));
            }
        }
        return names;
    }

    private static BeanDefinition getBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
            if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                return AbstractDependsOnBeanFactoryPostProcessor.getBeanDefinition(beanName, (ConfigurableListableBeanFactory)parentBeanFactory);
            }
            throw ex;
        }
    }
}

