/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationprocessor.fieldvalues.javac;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.springframework.boot.configurationprocessor.fieldvalues.FieldValuesParser;
import org.springframework.boot.configurationprocessor.fieldvalues.javac.ExpressionTree;
import org.springframework.boot.configurationprocessor.fieldvalues.javac.Tree;
import org.springframework.boot.configurationprocessor.fieldvalues.javac.TreeVisitor;
import org.springframework.boot.configurationprocessor.fieldvalues.javac.Trees;
import org.springframework.boot.configurationprocessor.fieldvalues.javac.VariableTree;

public class JavaCompilerFieldValuesParser
implements FieldValuesParser {
    private final Trees trees;

    public JavaCompilerFieldValuesParser(ProcessingEnvironment env) throws Exception {
        this.trees = Trees.instance(env);
    }

    @Override
    public Map<String, Object> getFieldValues(TypeElement element) throws Exception {
        Tree tree = this.trees.getTree(element);
        if (tree != null) {
            FieldCollector fieldCollector = new FieldCollector();
            tree.accept(fieldCollector);
            return fieldCollector.getFieldValues();
        }
        return Collections.emptyMap();
    }

    private static class FieldCollector
    implements TreeVisitor {
        private static final Map<String, Class<?>> WRAPPER_TYPES;
        private static final Map<Class<?>, Object> DEFAULT_TYPE_VALUES;
        private static final Map<String, Object> WELL_KNOWN_STATIC_FINALS;
        private final Map<String, Object> fieldValues = new HashMap<String, Object>();
        private final Map<String, Object> staticFinals = new HashMap<String, Object>();

        private FieldCollector() {
        }

        @Override
        public void visitVariable(VariableTree variable) throws Exception {
            Set<Modifier> flags = variable.getModifierFlags();
            if (flags.contains((Object)Modifier.STATIC) && flags.contains((Object)Modifier.FINAL)) {
                this.staticFinals.put(variable.getName(), this.getValue(variable));
            }
            if (!flags.contains((Object)Modifier.FINAL)) {
                this.fieldValues.put(variable.getName(), this.getValue(variable));
            }
        }

        private Object getValue(VariableTree variable) throws Exception {
            ExpressionTree initializer = variable.getInitializer();
            Class<?> wrapperType = WRAPPER_TYPES.get(variable.getType());
            Object defaultValue = DEFAULT_TYPE_VALUES.get(wrapperType);
            if (initializer != null) {
                return this.getValue(initializer, defaultValue);
            }
            return defaultValue;
        }

        private Object getValue(ExpressionTree expression, Object defaultValue) throws Exception {
            Object literalValue = expression.getLiteralValue();
            if (literalValue != null) {
                return literalValue;
            }
            Object factoryValue = expression.getFactoryValue();
            if (factoryValue != null) {
                return factoryValue;
            }
            List<? extends ExpressionTree> arrayValues = expression.getArrayExpression();
            if (arrayValues != null) {
                Object[] result = new Object[arrayValues.size()];
                for (int i = 0; i < arrayValues.size(); ++i) {
                    Object value = this.getValue(arrayValues.get(i), null);
                    if (value == null) {
                        return defaultValue;
                    }
                    result[i] = value;
                }
                return result;
            }
            if (expression.getKind().equals("IDENTIFIER")) {
                return this.staticFinals.get(expression.toString());
            }
            if (expression.getKind().equals("MEMBER_SELECT")) {
                return WELL_KNOWN_STATIC_FINALS.get(expression.toString());
            }
            return defaultValue;
        }

        public Map<String, Object> getFieldValues() {
            return this.fieldValues;
        }

        static {
            HashMap<String, Class<Long>> types = new HashMap<String, Class<Long>>();
            types.put("boolean", Boolean.class);
            types.put(Boolean.class.getName(), Boolean.class);
            types.put("byte", Byte.class);
            types.put(Byte.class.getName(), Byte.class);
            types.put("short", Short.class);
            types.put(Short.class.getName(), Short.class);
            types.put("int", Integer.class);
            types.put(Integer.class.getName(), Integer.class);
            types.put("long", Long.class);
            types.put(Long.class.getName(), Long.class);
            WRAPPER_TYPES = Collections.unmodifiableMap(types);
            HashMap<Object, Comparable<Boolean>> values = new HashMap<Object, Comparable<Boolean>>();
            values.put(Boolean.class, Boolean.valueOf(false));
            values.put(Byte.class, Byte.valueOf((byte)0));
            values.put(Short.class, Short.valueOf((short)0));
            values.put(Integer.class, Integer.valueOf(0));
            values.put(Long.class, Long.valueOf(0L));
            DEFAULT_TYPE_VALUES = Collections.unmodifiableMap(values);
            values = new HashMap();
            values.put("Boolean.TRUE", Boolean.valueOf(true));
            values.put("Boolean.FALSE", Boolean.valueOf(false));
            WELL_KNOWN_STATIC_FINALS = Collections.unmodifiableMap(values);
        }
    }
}

