/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.properties;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.test.autoconfigure.properties.PropertyMapping;
import org.springframework.boot.test.autoconfigure.properties.SkipPropertyMapping;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AnnotationsPropertySource
extends EnumerablePropertySource<Class<?>> {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([^A-Z-])([A-Z])");
    private final Map<String, Object> properties;

    public AnnotationsPropertySource(Class<?> source) {
        this("Annotations", source);
    }

    public AnnotationsPropertySource(String name, Class<?> source) {
        super(name, source);
        this.properties = this.getProperties(source);
    }

    private Map<String, Object> getProperties(Class<?> source) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.collectProperties(source, source, properties, new HashSet());
        return Collections.unmodifiableMap(properties);
    }

    private void collectProperties(Class<?> root, Class<?> source, Map<String, Object> properties, Set<Class<?>> seen) {
        if (source != null && seen.add(source)) {
            for (Annotation annotation : this.getMergedAnnotations(root, source)) {
                if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)annotation)) continue;
                PropertyMapping typeMapping = annotation.annotationType().getAnnotation(PropertyMapping.class);
                for (Method attribute : annotation.annotationType().getDeclaredMethods()) {
                    this.collectProperties(annotation, attribute, typeMapping, properties);
                }
                this.collectProperties(root, annotation.annotationType(), properties, seen);
            }
            this.collectProperties(root, source.getSuperclass(), properties, seen);
        }
    }

    private List<Annotation> getMergedAnnotations(Class<?> root, Class<?> source) {
        ArrayList<Annotation> mergedAnnotations = new ArrayList<Annotation>();
        for (Annotation annotation : AnnotationUtils.getAnnotations(source)) {
            if (AnnotationUtils.isInJavaLangAnnotationPackage((Annotation)annotation)) continue;
            mergedAnnotations.add(this.findMergedAnnotation(root, annotation.annotationType()));
        }
        return mergedAnnotations;
    }

    private Annotation findMergedAnnotation(Class<?> source, Class<? extends Annotation> annotationType) {
        if (source == null) {
            return null;
        }
        Annotation mergedAnnotation = AnnotatedElementUtils.getMergedAnnotation(source, annotationType);
        return mergedAnnotation != null ? mergedAnnotation : this.findMergedAnnotation(source.getSuperclass(), annotationType);
    }

    private void collectProperties(Annotation annotation, Method attribute, PropertyMapping typeMapping, Map<String, Object> properties) {
        Object defaultValue;
        PropertyMapping attributeMapping = (PropertyMapping)AnnotationUtils.getAnnotation((Method)attribute, PropertyMapping.class);
        SkipPropertyMapping skip = this.getMappingType(typeMapping, attributeMapping);
        if (skip == SkipPropertyMapping.YES) {
            return;
        }
        String name = this.getName(typeMapping, attributeMapping, attribute);
        ReflectionUtils.makeAccessible((Method)attribute);
        Object value = ReflectionUtils.invokeMethod((Method)attribute, (Object)annotation);
        if (skip == SkipPropertyMapping.ON_DEFAULT_VALUE && ObjectUtils.nullSafeEquals((Object)value, (Object)(defaultValue = AnnotationUtils.getDefaultValue((Annotation)annotation, (String)attribute.getName())))) {
            return;
        }
        this.putProperties(name, value, properties);
    }

    private SkipPropertyMapping getMappingType(PropertyMapping typeMapping, PropertyMapping attributeMapping) {
        if (attributeMapping != null) {
            return attributeMapping.skip();
        }
        if (typeMapping != null) {
            return typeMapping.skip();
        }
        return SkipPropertyMapping.YES;
    }

    private String getName(PropertyMapping typeMapping, PropertyMapping attributeMapping, Method attribute) {
        String name;
        String prefix = typeMapping == null ? "" : typeMapping.value();
        String string = name = attributeMapping == null ? "" : attributeMapping.value();
        if (!StringUtils.hasText((String)name)) {
            name = this.toKebabCase(attribute.getName());
        }
        return this.dotAppend(prefix, name);
    }

    private String toKebabCase(String name) {
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(name);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, matcher.group(1) + '-' + StringUtils.uncapitalize((String)matcher.group(2)));
        }
        matcher.appendTail(result);
        return result.toString().toLowerCase();
    }

    private String dotAppend(String prefix, String postfix) {
        if (StringUtils.hasText((String)prefix)) {
            return prefix.endsWith(".") ? prefix + postfix : prefix + "." + postfix;
        }
        return postfix;
    }

    private void putProperties(String name, Object value, Map<String, Object> properties) {
        if (ObjectUtils.isArray((Object)value)) {
            Object[] array = ObjectUtils.toObjectArray((Object)value);
            for (int i = 0; i < array.length; ++i) {
                properties.put(name + "[" + i + "]", array[i]);
            }
        } else {
            properties.put(name, value);
        }
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String[] getPropertyNames() {
        return StringUtils.toStringArray(this.properties.keySet());
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public int hashCode() {
        return this.properties.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        return this.properties.equals(((AnnotationsPropertySource)((Object)obj)).properties);
    }
}

