/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.restdocs;

import io.restassured.builder.RequestSpecBuilder;
import io.restassured.filter.Filter;
import io.restassured.specification.RequestSpecification;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsMockMvcBuilderCustomizer;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsMockMvcConfigurationCustomizer;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsProperties;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsRestAssuredBuilderCustomizer;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsRestAssuredConfigurationCustomizer;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsWebTestClientBuilderCustomizer;
import org.springframework.boot.test.autoconfigure.restdocs.RestDocsWebTestClientConfigurationCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.restdocs.RestDocumentationContextProvider;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentation;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentationConfigurer;
import org.springframework.restdocs.mockmvc.RestDocumentationResultHandler;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentation;
import org.springframework.restdocs.restassured3.RestAssuredRestDocumentationConfigurer;
import org.springframework.restdocs.webtestclient.WebTestClientRestDocumentation;
import org.springframework.restdocs.webtestclient.WebTestClientRestDocumentationConfigurer;

@Configuration
@ConditionalOnWebApplication
public class RestDocsAutoConfiguration {

    @Configuration
    @ConditionalOnClass(value={WebTestClientRestDocumentation.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @EnableConfigurationProperties(value={RestDocsProperties.class})
    static class RestDocsWebTestClientAutoConfiguration {
        RestDocsWebTestClientAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={WebTestClientRestDocumentationConfigurer.class})
        public WebTestClientRestDocumentationConfigurer restDocsWebTestClientConfigurer(ObjectProvider<RestDocsWebTestClientConfigurationCustomizer> configurationCustomizerProvider, RestDocumentationContextProvider contextProvider) {
            WebTestClientRestDocumentationConfigurer configurer = WebTestClientRestDocumentation.documentationConfiguration((RestDocumentationContextProvider)contextProvider);
            RestDocsWebTestClientConfigurationCustomizer configurationCustomizer = (RestDocsWebTestClientConfigurationCustomizer)configurationCustomizerProvider.getIfAvailable();
            if (configurationCustomizer != null) {
                configurationCustomizer.customize(configurer);
            }
            return configurer;
        }

        @Bean
        public RestDocsWebTestClientBuilderCustomizer restDocumentationConfigurer(RestDocsProperties properties, WebTestClientRestDocumentationConfigurer configurer) {
            return new RestDocsWebTestClientBuilderCustomizer(properties, configurer);
        }
    }

    @Configuration
    @ConditionalOnClass(value={RequestSpecification.class, RestAssuredRestDocumentation.class})
    @EnableConfigurationProperties(value={RestDocsProperties.class})
    static class RestDocsRestAssuredAutoConfiguration {
        RestDocsRestAssuredAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={RequestSpecification.class})
        public RequestSpecification restDocsRestAssuredConfigurer(ObjectProvider<RestDocsRestAssuredConfigurationCustomizer> configurationCustomizerProvider, RestDocumentationContextProvider contextProvider) {
            RestAssuredRestDocumentationConfigurer configurer = RestAssuredRestDocumentation.documentationConfiguration((RestDocumentationContextProvider)contextProvider);
            RestDocsRestAssuredConfigurationCustomizer configurationCustomizer = (RestDocsRestAssuredConfigurationCustomizer)configurationCustomizerProvider.getIfAvailable();
            if (configurationCustomizer != null) {
                configurationCustomizer.customize(configurer);
            }
            return new RequestSpecBuilder().addFilter((Filter)configurer).build();
        }

        @Bean
        public RestDocsRestAssuredBuilderCustomizer restAssuredBuilderCustomizer(RestDocsProperties properties, RequestSpecification configurer) {
            return new RestDocsRestAssuredBuilderCustomizer(properties, configurer);
        }
    }

    @Configuration
    @ConditionalOnClass(value={MockMvcRestDocumentation.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @EnableConfigurationProperties(value={RestDocsProperties.class})
    static class RestDocsMockMvcAutoConfiguration {
        RestDocsMockMvcAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={MockMvcRestDocumentationConfigurer.class})
        public MockMvcRestDocumentationConfigurer restDocsMockMvcConfigurer(ObjectProvider<RestDocsMockMvcConfigurationCustomizer> configurationCustomizerProvider, RestDocumentationContextProvider contextProvider) {
            MockMvcRestDocumentationConfigurer configurer = MockMvcRestDocumentation.documentationConfiguration((RestDocumentationContextProvider)contextProvider);
            RestDocsMockMvcConfigurationCustomizer configurationCustomizer = (RestDocsMockMvcConfigurationCustomizer)configurationCustomizerProvider.getIfAvailable();
            if (configurationCustomizer != null) {
                configurationCustomizer.customize(configurer);
            }
            return configurer;
        }

        @Bean
        public RestDocsMockMvcBuilderCustomizer restDocumentationConfigurer(RestDocsProperties properties, MockMvcRestDocumentationConfigurer configurer, ObjectProvider<RestDocumentationResultHandler> resultHandler) {
            return new RestDocsMockMvcBuilderCustomizer(properties, configurer, (RestDocumentationResultHandler)resultHandler.getIfAvailable());
        }
    }
}

