/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.reactive.context;

import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext;
import org.springframework.boot.web.reactive.context.ReactiveWebServerInitializedEvent;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContextException;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class ReactiveWebServerApplicationContext
extends GenericReactiveWebApplicationContext
implements ConfigurableWebServerApplicationContext {
    private volatile ServerManager serverManager;
    private String serverNamespace;

    public ReactiveWebServerApplicationContext() {
    }

    public ReactiveWebServerApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
    }

    public final void refresh() throws BeansException, IllegalStateException {
        try {
            super.refresh();
        }
        catch (RuntimeException ex) {
            this.stopAndReleaseReactiveWebServer();
            throw ex;
        }
    }

    protected void onRefresh() {
        super.onRefresh();
        try {
            this.createWebServer();
        }
        catch (Throwable ex) {
            throw new ApplicationContextException("Unable to start reactive web server", ex);
        }
    }

    private void createWebServer() {
        ServerManager serverManager = this.serverManager;
        if (serverManager == null) {
            String webServerFactoryBeanName = this.getWebServerFactoryBeanName();
            ReactiveWebServerFactory webServerFactory = this.getWebServerFactory(webServerFactoryBeanName);
            boolean lazyInit = this.getBeanFactory().getBeanDefinition(webServerFactoryBeanName).isLazyInit();
            this.serverManager = ServerManager.get(webServerFactory, lazyInit);
        }
        this.initPropertySources();
    }

    protected String getWebServerFactoryBeanName() {
        Object[] beanNames = this.getBeanFactory().getBeanNamesForType(ReactiveWebServerFactory.class);
        if (beanNames.length == 0) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to missing ReactiveWebServerFactory bean.");
        }
        if (beanNames.length > 1) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to multiple ReactiveWebServerFactory beans : " + StringUtils.arrayToCommaDelimitedString((Object[])beanNames));
        }
        return beanNames[0];
    }

    protected ReactiveWebServerFactory getWebServerFactory(String factoryBeanName) {
        return (ReactiveWebServerFactory)this.getBeanFactory().getBean(factoryBeanName, ReactiveWebServerFactory.class);
    }

    @Deprecated
    protected ReactiveWebServerFactory getWebServerFactory() {
        return this.getWebServerFactory(this.getWebServerFactoryBeanName());
    }

    protected void finishRefresh() {
        super.finishRefresh();
        WebServer webServer = this.startReactiveWebServer();
        if (webServer != null) {
            this.publishEvent(new ReactiveWebServerInitializedEvent(webServer, this));
        }
    }

    private WebServer startReactiveWebServer() {
        ServerManager serverManager = this.serverManager;
        ServerManager.start(serverManager, this::getHttpHandler);
        return ServerManager.getWebServer(serverManager);
    }

    protected HttpHandler getHttpHandler() {
        Object[] beanNames = this.getBeanFactory().getBeanNamesForType(HttpHandler.class);
        if (beanNames.length == 0) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to missing HttpHandler bean.");
        }
        if (beanNames.length > 1) {
            throw new ApplicationContextException("Unable to start ReactiveWebApplicationContext due to multiple HttpHandler beans : " + StringUtils.arrayToCommaDelimitedString((Object[])beanNames));
        }
        return (HttpHandler)this.getBeanFactory().getBean(beanNames[0], HttpHandler.class);
    }

    protected void onClose() {
        super.onClose();
        this.stopAndReleaseReactiveWebServer();
    }

    private void stopAndReleaseReactiveWebServer() {
        ServerManager serverManager = this.serverManager;
        try {
            ServerManager.stop(serverManager);
        }
        finally {
            this.serverManager = null;
        }
    }

    @Override
    public WebServer getWebServer() {
        return ServerManager.getWebServer(this.serverManager);
    }

    @Override
    public String getServerNamespace() {
        return this.serverNamespace;
    }

    @Override
    public void setServerNamespace(String serverNamespace) {
        this.serverNamespace = serverNamespace;
    }

    static final class ServerManager
    implements HttpHandler {
        private final WebServer server;
        private final boolean lazyInit;
        private volatile HttpHandler handler = this::handleUninitialized;

        private ServerManager(ReactiveWebServerFactory factory, boolean lazyInit) {
            this.server = factory.getWebServer(this);
            this.lazyInit = lazyInit;
        }

        private Mono<Void> handleUninitialized(ServerHttpRequest request, ServerHttpResponse response) {
            throw new IllegalStateException("The HttpHandler has not yet been initialized");
        }

        public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
            return this.handler.handle(request, response);
        }

        HttpHandler getHandler() {
            return this.handler;
        }

        static ServerManager get(ReactiveWebServerFactory factory, boolean lazyInit) {
            return new ServerManager(factory, lazyInit);
        }

        static WebServer getWebServer(ServerManager manager) {
            return manager != null ? manager.server : null;
        }

        static void start(ServerManager manager, Supplier<HttpHandler> handlerSupplier) {
            if (manager != null && manager.server != null) {
                manager.handler = manager.lazyInit ? new LazyHttpHandler(Mono.fromSupplier(handlerSupplier)) : handlerSupplier.get();
                manager.server.start();
            }
        }

        static void stop(ServerManager manager) {
            if (manager != null && manager.server != null) {
                try {
                    manager.server.stop();
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    private static final class LazyHttpHandler
    implements HttpHandler {
        private final Mono<HttpHandler> delegate;

        private LazyHttpHandler(Mono<HttpHandler> delegate) {
            this.delegate = delegate;
        }

        public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
            return this.delegate.flatMap(handler -> handler.handle(request, response));
        }
    }
}

